<?php 
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Conexão com o banco de dados SQLite (caso precise para outras operações)
$db = new SQLite3('api/.db.db');

// Verifica se o formulário foi enviado
if (isset($_POST['submit'])) {
    // Verifica se o arquivo foi enviado corretamente
    if (isset($_FILES['apk_file']) && $_FILES['apk_file']['error'] === UPLOAD_ERR_OK) {
        
        $uploadDir = 'upload/';  // Pasta para armazenar o arquivo
        $filename = basename($_FILES['apk_file']['name']);
        $targetFilePath = $uploadDir . $filename;

        // Move o arquivo para a pasta de uploads
        if (move_uploaded_file($_FILES['apk_file']['tmp_name'], $targetFilePath)) {
            // Gera a URL do arquivo
            $urlGerada = 'https://' . $_SERVER['HTTP_HOST'] . '/loja/' . $uploadDir . $filename;


            // Redireciona para o arquivo upload_url.php com a URL gerada como parâmetro
            header("Location: upload_url.php?url=" . urlencode($urlGerada));
            exit();
        } else {
            echo "<script>alert('Erro ao mover o arquivo!');</script>";
        }
    } else {
        echo "<script>alert('Erro no envio do arquivo!');</script>";
    }
}
?>


<!DOCTYPE html>
<html lang="pt-br">
    
    <?php include ('header.php') ?>
<head>
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload de APK - App Store 2.0</title>
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/apple-icon.png">
    <link rel="icon" type="image/png" href="assets/img/favicon.png">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <link href="assets/css/material-dashboard.css?v=2.1.2" rel="stylesheet" />
    <link href="assets/demo/demo.css" rel="stylesheet" />
    <style>
        /* Estilo para o campo de texto que simula uma caixa de pesquisa */
        .file-input {
            background-color: #f4f4f4;
            color: #aaa;
            border: 1px solid #ccc;
            padding: 10px;
            width: calc(100% - 120px); /* Reduzindo o tamanho da caixa de texto */
            font-size: 16px;
            border-radius: 5px;
            margin-right: 10px; /* Espaço entre a caixa de texto e o botão */
            cursor: pointer; /* Faz a caixa de texto parecer clicável */
        }

        /* Estilo para esconder o input de arquivo, mas deixar ele funcional */
        .file-input-hidden {
            display: none;
        }

        /* Estilo para o botão */
.btn-upload {
    background-color: rgba(10, 194, 56, 0.9); /* Cor verde com opacidade */
    color: black;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
    border-radius: 5px;
    border: none;
}

.btn-upload:hover {
    background-color: rgba(10, 194, 566, 1); /* Cor verde sólida quando passa o mouse */
}


        .form-upload {
            margin-top: 30px;
            display: flex;
            align-items: center; /* Alinha a caixa de texto e o botão na horizontal */
        }

        h2 {
    font-size: 20px;
    color: rgb(255, 0, 0);  /* Cor RGB modificável para vermelho */
    margin-bottom: 20px;
}


        /* Estilo para o título */
        .titulo-upload h2 {
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <?php include ('header.php') ?>

    <div class="main-panel">
      <!-- Navbar -->
      <nav class="navbar navbar-expand-lg navbar-transparent navbar-absolute fixed-top ">
        <div class="container-fluid">
          <div class="navbar-wrapper">
                    <!--<a class="navbar-brand" href="#">Upload de APK</a>-->
                </div>
            </div>
        </nav>

        <div class="content">
            <div class="container-fluid">
                <!-- Título de Upload -->
                <div class="titulo-upload">
                    <h2>Upload de APK</h2>
                </div>

                <!-- Formulário de upload -->
                <form action="" method="post" enctype="multipart/form-data" class="form-upload">
                    <div class="form-group">
                        <!-- Caixa de texto clicável, mas com input de arquivo escondido por trás -->
                        <input type="text" id="apk_text" class="file-input" placeholder="Selecione o arquivo APK" readonly onclick="document.getElementById('apk_file').click();">
                        <input type="file" name="apk_file" id="apk_file" class="file-input-hidden" required>
                        <button type="submit" name="submit" class="btn-upload">Enviar</button>
                    </div>
                </form>

                <!-- Exibição da URL gerada -->
                <?php
                if (!empty($urlGerada)) {
                    echo "<h3>Arquivo enviado com sucesso!</h3>";
                    echo "<p>URL gerada para o arquivo: <a href='" . $urlGerada . "' target='_blank'>" . $urlGerada . "</a></p>";
                }
                ?>
            </div>
        </div>
    </div>

    <!-- Script JavaScript para atualizar a caixa de texto com o nome do arquivo -->
    <script>
        document.getElementById('apk_file').addEventListener('change', function() {
            var fileName = this.files[0].name;
            document.getElementById('apk_text').value = fileName;
        });
    </script>

    <!-- JavaScript Files -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="assets/js/material-dashboard.js?v=2.1.2"></script>
</body>
</html>

<?php
// Finaliza o buffer de saída
ob_end_flush();
?>
