<?php
include "./autoload.php";
include "./admin/configuracoes/functions.php";

// Configuração do CORS para permitir todas as origens
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Obtenha todos os aplicativos da classe Aplicativos
$aplicativos = new Aplicativos;
$getAllApps = $aplicativos->getAllApplications();
if (!$getAllApps['status']) {
    die("Error fetching applications.");
}


// Inicialize os arrays para os itens IPTV e P2P
$iptvItems = [];
$p2pItems = [];

// Adicionar os índices corretos e separar itens P2P
foreach ($getAllApps['data'] as $item) {
    $formattedItem = [
        "id" => $item['id'],
        "images" => json_decode($item['imagens'], true),
        "title" => $item['name'],
        "size" => $item['size'] . " MB",
        "downloads" => $item['downloadsQuantity'] . "+",
        "rating" => $item['rating'] . " estrelas",
        "developer" => ucfirst($item['developer']),
        "description" => $item['description'],
        "codigoDownloader" => $item['downloader'],
        "codigoNTDown" => $item['ntdown'],
        "order" => $item['orderBy'],
        "status" => $item['status'],
        "downloadUrl" => URL_BASE . "/download/" . basename($item['link'])
    ];

    // Separar itens P2P
    if ($item['p2p'] === "Yes") {
        $p2pItems[] = $formattedItem;
    } else {
        $iptvItems[] = $formattedItem;
    }
}

// Atualizar o array com os itens formatados
$appsArray['iptvItems'] = $iptvItems;
$appsArray['p2pItems'] = $p2pItems;

// Codificar o array de volta para JSON
$appsWithId = json_encode($appsArray, JSON_PRETTY_PRINT);

// Exemplo de uso
$ofuscador = new Ofuscador();
$textoCriptografado = $ofuscador->criptografar($appsWithId);
echo base64_encode($textoCriptografado);
