$(document).on("click", "#submitLogin", function(e) {
    e.preventDefault();

    const email = $("#email").val().trim();
    const password = $("#password").val().trim();

    if (email.length < 1) {
        toastr.error("Você não digitou o seu email");
        return;
    }

    if (password.length < 1) {
        toastr.error("A senha não pode ser vazia");
        return;
    }

    $.post("./api/login/auth", { email: email, password: password }, function(response) {
        if (response.status) {
        	toastr.success(response.message);
            setTimeout(function() {
                window.location.href = "home";
            }, 2000);
        } else {
            toastr.error(response.message);
        }
    }, "json").fail(function() {
        toastr.error("Ocorreu um erro ao tentar se comunicar com o servidor.");
    });
});