$(document).on("click", ".statusApp", function(e) {
    e.preventDefault();

    var appId = $(this).data("id"); // Assume que o ID do aplicativo está armazenado no atributo data-id do botão
    var currentStatus = $(this).data("status"); // Assume que o status atual do aplicativo está armazenado no atributo data-status do botão
    var newStatus = currentStatus === 'Active' ? 'Inactive' : 'Active';
    var statusText = newStatus === 'Active' ? 'ativar' : 'desativar';

    bootbox.dialog({
        title: "Confirmação de " + statusText,
        message: "Você tem certeza de que deseja " + statusText + " este aplicativo? Esta ação pode ser desfeita.",
        buttons: {
            noclose: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-check mr-2' ></i> Confirmar </div>",
                className: 'btn btn-sm btn-primary',
                callback: function() {
                    // Mostrar o overlay
                    $.blockUI({ message: '<h1>Processando...</h1>', css: { border: 'none', padding: '15px', backgroundColor: '#fff', 'border-radius': '10px', opacity: .8, color: '#000' } });
                    
                    $.ajax({
                        url: "./api/aplicativos/status", // URL para o endpoint de ativação/desativação
                        type: "POST",
                        data: { id: appId, status: newStatus },
                        success: function(res) {
                            $.unblockUI(); // Remove o overlay em caso de erro
                            if (res.status) {
                                toastr.success(res.message);
                                // Atualizar o status na interface
                                $(`#app-${appId}`).data("status", newStatus);
                                $(`#app-${appId} .status-label`).text(newStatus); // Atualize a exibição do status conforme necessário
                            } else {
                                toastr.error(res.message);
                            }
                        },
                        error: function() {
                            $.unblockUI(); // Remove o overlay em caso de erro
                            toastr.error('Ocorreu um erro ao processar a solicitação.');
                        }
                    });
                }
            },
            noclose2: {
                label: "<div class='d-flex align-items-center'><i class='bx bx-x mr-2' ></i> Cancelar </div>",
                className: 'btn btn-sm btn-danger',
                callback: function() {
                    $(this).modal('hide');
                    return false;
                }
            }
        }
    }).find(".modal-dialog").addClass("modal-dialog-centered").find('.modal-header').css({
        'background-color': '#2A2A2A'
    }).find('.modal-title').css({
        'color': '#fff'
    }).find('.modal-header .close').css({
        'color': '#fff'
    });
});
