$(document).on("click", ".editarApp", function(e){
    e.preventDefault();


    /**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */
    
    const id = $(this).data("id");

    $.get("./api/aplicativos/informacoes", { id: id }, function(response){
        if(response.status){
            var myDropzone;

            // Função para criar um novo input dinamicamente
            function criarInput(url = '') {
                const inputHtml = `
                    <div class="input-group mb-2 app-input input-primary">
                        <input type="text" class="form-control" value="${url}" placeholder="Ex: https://imgur.com/kAmnSof.png">
                        <div class="input-group-append">
                            <button class="btn btn-sm btn-danger removerInput" type="button">Remover</button>
                        </div>
                    </div>`;
                $("#inputsContainer").append(inputHtml);
            }

            // Formulário base, incluindo o original e o novo contêiner de inputs dinâmicos
            const form = `
                <div class="basic-form">
                    <div class="form-row">
                        <div class="form-group col-md-6 input-primary">
                            <label><strong>Nome do aplicativo*</strong></label>
                            <input type="text" class="form-control" placeholder="Ex: Aplicativo para tv box" id="nome" required>
                        </div>
                        <div class="form-group col-md-6 input-primary">
                            <label><strong>Nome do desenvolvedor*</strong></label>
                            <input type="text" class="form-control" placeholder="Ex: script php brasil" id="desenvolvedor" required>
                        </div>
                        <div class="form-group col-md-4 input-primary">
                            <label><strong>Categoria*</strong></label>
                            <select class="form-control default-select" id="tipo">
                                <option value="No">IPTV</option>
                                <option value="Yes">P2P</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4 input-primary">
                            <label><strong>Ordem de exibição*</strong></label>
                            <input type="number" class="form-control" min="1" value="1" placeholder="Ex: 1,2,3 ..." id="ordem" required>
                        </div>
                        <div class="form-group col-md-4 input-primary">
                            <label><strong>Estrelas*</strong></label>
                            <input type="text" class="form-control" placeholder="Ex: 4.5, 5, 2.3" id="estrelas" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6 input-primary">
                            <label><strong>Downloader by AFTVnews (código)*</strong></label>
                            <input type="text" class="form-control" placeholder="Ex: 479789" id="codigoAFTV" required>
                        </div>
                        <div class="form-group col-md-6 input-primary">
                            <label><strong>NTDown (código)*</strong></label>
                            <input type="text" class="form-control" placeholder="Ex: 789244" id="codigoNTDown" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-12 input-primary">
                            <label><strong>Descrição do aplicativo*</strong></label>
                            <textarea class="form-control" rows="5" cols="50" placeholder="Ex: O novo aplicativo conta com uma série de novas funcionalidades melhoradas nessa nova versão." id="descricao"></textarea>
                        </div>
                    </div>
                    <div id="inputsContainer">
                        <label><strong>Imagens do aplicativo Tamanho 1280 x 603*</strong></label>
                        <!-- Imagens adicionadas dinamicamente aqui -->
                    </div>
                    <button class="btn btn-sm btn-primary adicionarNovoInput mt-3 mb-3" type="button">Adicionar imagem</button>
                    <div class="form-row">
                        <label><strong>Selecione o novo aplicativo*</strong></label>
                        <div class="input-group mb-2 app-input input-primary">
                            <form class="dropzone col-md-12" id="appDropzone"></form>
                        </div>
                    </div>
                </div>
            `;

            var dialog2 = bootbox.dialog({
                size: 'large',
                title: "Editar aplicativo 🟢",
                message: form,
                className: "modal-success",
                buttons: {
                    noclose: {
                        label: "<div class='d-flex align-items-center'><i class='bx bx-check mr-2' ></i> Atualizar </div>",
                        className: 'btn btn-sm btn-primary',
                        callback: function() {
                            // Mostrar o overlay
                            $.blockUI({ message: '<h1>Processando...</h1>', css: { border: 'none', padding: '15px', backgroundColor: '#fff', 'border-radius': '10px', opacity: .8, color: '#000' } });
                            
                            // Cria um FormData object
                            let formData = new FormData();
                            formData.append('id', id);
                            formData.append('nome', $("#nome").val());
                            formData.append('desenvolvedor', $("#desenvolvedor").val());
                            formData.append('tipo', $("#tipo").val());
                            formData.append('ordem', $("#ordem").val());
                            formData.append('estrelas', $("#estrelas").val());
                            formData.append('codigoAFTV', $("#codigoAFTV").val());
                            formData.append('codigoNTDown', $("#codigoNTDown").val());
                            formData.append('descricao', $("#descricao").val());

                            var imagensDoAplicativo = [];
                            $("#inputsContainer .app-input input").each(function() {
                                if($(this).val()){
                                    imagensDoAplicativo.push($(this).val());
                                }
                            });
                            formData.append('imagensDoAplicativo', JSON.stringify(imagensDoAplicativo));

                            // Adiciona arquivos do Dropzone ao formData
                            if (myDropzone && myDropzone.getAcceptedFiles().length > 0) {
                                myDropzone.getAcceptedFiles().forEach(function(file) {
                                    formData.append('files[]', file);
                                });
                            }

                            $.ajax({
                                url: "./api/aplicativos/editar",
                                type: "POST",
                                data: formData,
                                processData: false,
                                contentType: false,
                                success: function(res) {
                                    $.unblockUI(); // Remove o overlay em caso de erro
                                    if (res.status) {
                                        toastr.success(res.message);
                                    } else {
                                        toastr.error(res.message);
                                    }
                                },
                                error: function() {
                                    $.unblockUI(); // Remove o overlay em caso de erro
                                    toastr.error('Ocorreu um erro ao processar a solicitação.');
                                }
                            });
                        }
                    },
                    noclose2: {
                        label: "<div class='d-flex align-items-center'><i class='bx bx-x mr-2' ></i> Cancelar </div>",
                        className: 'btn btn-sm btn-danger',
                        callback: function() {
                            $(this).modal('hide');
                            return false;
                        }
                    }
                }
            }).on('shown.bs.modal', function (e) {
                // Inicializa o Dropzone com upload manual e limite de 1 arquivo
                myDropzone = new Dropzone("#appDropzone", {
                    url: "/", // URL não utilizada, o envio é feito manualmente
                    autoProcessQueue: false, // Desativa o envio automático
                    paramName: "file",
                    maxFiles: 1, // Permitir apenas 1 arquivo
                    acceptedFiles: ".apk",
                    dictDefaultMessage: "Arraste e solte o arquivo aqui ou clique para selecionar",
                    init: function() {
                        this.on("addedfile", function(file) {
                            if (this.files.length > 1) {
                                this.removeFile(this.files[0]); // Remove o arquivo anterior se um novo for adicionado
                            }
                        });
                        this.on("error", function(file, response) {
                            console.error("Erro ao enviar o arquivo:", response);
                        });
                        myDropzone = this; // Define a variável global myDropzone
                    }
                });

                // Preenche os campos com dados da API
                $("#nome").val(response.data.name);
                $("#desenvolvedor").val(response.data.developer);
                $("#tipo").val(response.data.p2p);
                $("#ordem").val(response.data.orderBy);
                $("#estrelas").val(response.data.rating);
                $("#codigoAFTV").val(response.data.downloader);
                $("#codigoNTDown").val(response.data.ntdown);
                $("#descricao").val(response.data.description);

                // Adiciona imagens ao contêiner
                try {
                    const imagens = JSON.parse(response.data.imagens); // Converte a string JSON para array
                    if (Array.isArray(imagens)) {
                        imagens.forEach(url => {
                            criarInput(url);
                        });
                    } else {
                        console.warn("O formato das imagens não é um array.");
                    }
                } catch (e) {
                    console.error("Erro ao parsear a string JSON das imagens:", e);
                }

                // Evento para adicionar novo input
                $(document).on("click", ".adicionarNovoInput", function() {
                    criarInput();
                });

                // Evento para remover input, garantindo que pelo menos um permaneça
                $(document).on("click", ".removerInput", function() {
                    if ($('.removerInput').length > 1) {
                        $(this).closest(".app-input").remove();
                    }
                });
            }).find(".modal-dialog").addClass("modal-dialog-centered").find('.modal-header').css({
                'background-color': '#2A2A2A'
            }).find('.modal-title').css({
                'color': '#fff'
            }).find('.modal-header .close').css({
                'color': '#fff'
            });
        } else {
            toastr.error("Não foi possível carregar as informações do aplicativo.");
        }
    }, "JSON");
});
