<?php

/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */
class Usuario
{
	
	public function authenticator($email, $password)
	{

		$pass = crypt($password, '$6$rounds=20000$i9teamAppStore$');


		$PDO = conexaoPDOlocal();

		if ($PDO !== NULL) {
			$sql = "SELECT * FROM `usuarios` WHERE `email` = :email AND `password` = :password;";
			$stmt = $PDO->prepare($sql);
			$stmt->bindParam(":email", $email, PDO::PARAM_STR, 255);
			$stmt->bindParam(":password", $pass, PDO::PARAM_STR, 255);
			if ($stmt->execute()) {
				$response = $stmt->fetch(PDO::FETCH_ASSOC);

				if(!empty($response)){
					session_start();
					$_SESSION["logged"] = true;
					$_SESSION["user_id"] = $response['id'];
					return ["status" => true, "message" => "Usuário autenticado com sucesso!", "user_id" => $response['id']];
				}else{
					return ["status" => false, "message" => "Os dados que você forneceu não existe ou estão incorretos!"];
				}
			}
		}
		return ["status" => false, "message" => "Houve um erro interno"];
	}
	
	// Método para atualizar a senha do usuário
    public function updatePassword($userId, $currentPassword, $newPassword)
    {
        // Conecta ao banco de dados
        $PDO = conexaoPDOlocal();
        if ($PDO !== NULL) {
            // Verifica a senha atual
            $currentPasswordHash = crypt($currentPassword, '$6$rounds=20000$i9teamAppStore$');
            $sql = "SELECT * FROM `usuarios` WHERE `id` = :id AND `password` = :currentPassword";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":id", $userId, PDO::PARAM_INT);
            $stmt->bindParam(":currentPassword", $currentPasswordHash, PDO::PARAM_STR);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                // Atualiza a senha se a senha atual estiver correta
                $newPasswordHash = crypt($newPassword, '$6$rounds=20000$i9teamAppStore$');
                $sql = "UPDATE `usuarios` SET `password` = :newPassword WHERE `id` = :id";
                $stmt = $PDO->prepare($sql);
                $params = [
                    ':id' => intval($userId),
                    ':newPassword' => $newPasswordHash
                ];

                if ($stmt->execute($params)) {
                    return ["status" => true, "message" => "Senha atualizada com sucesso"];
                } else {
                    return ["status" => false, "message" => "Falha ao atualizar a senha"];
                }
            } else {
                return ["status" => false, "message" => "Senha atual incorreta"];
            }
        }
        return ["status" => false, "message" => "Erro na conexão com o banco de dados"];
    }

}