<?php


/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */
class Aplicativos
{
    public function getAllApplications()
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "SELECT * FROM aplicativos ORDER BY orderBy ASC;";
            $stmt = $PDO->prepare($sql);
            if ($stmt->execute()) {
                $response = $stmt->fetchAll(PDO::FETCH_ASSOC);
                return ["status" => true, "message" => "List of applications", "data" => $response];
            }
        }
        return ["status" => false, "message" => "Internal error"];
    }

    public function getApplication($id)
    {
        $PDO = conexaoPDOlocal();
        if ($PDO !== NULL) {
            $sql = "SELECT * FROM aplicativos WHERE id = :id;";
            $stmt = $PDO->prepare($sql);
            $params = [':id' => intval($id)];
            if ($stmt->execute($params)) {
                $response = $stmt->fetch(PDO::FETCH_ASSOC);
                return ["status" => true, "message" => "List of application", "data" => $response];
            }
        }
        return ["status" => false, "message" => "Internal error"];
    }

    public function addApplication($name, $fileLink, $p2p, $orderBy, $rating, $size, $downloader, $ntdown, $description, $developer, $images)
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "INSERT INTO aplicativos (name, link, description, developer, downloadsQuantity, rating, size, downloader, ntdown, status, p2p, orderBy, imagens) 
                    VALUES (:name, :fileLink, :description, :developer, :downloadsQuantity, :rating, :size, :downloader, :ntdown, :status, :p2p, :orderBy, :images)";
            $stmt = $PDO->prepare($sql);
            $params = [
                ':name' => $name,
                ':fileLink' => $fileLink,
                ':description' => $description,
                ':developer' => $developer,
                ':downloadsQuantity' => 0, // Valor padrão
                ':rating' => $rating,
                ':size' => $size,
                ':downloader' => $downloader,
                ':ntdown' => $ntdown,
                ':status' => 'Active', // Valor padrão
                ':p2p' => $p2p,
                ':orderBy' => $orderBy,
                ':images' => json_encode($images),
            ];
            if ($stmt->execute($params)) {
                return ["status" => true, "message" => "Aplicação adicionada com sucesso"];
            }
        }
        return ["status" => false, "message" => "Falha ao adicionar o aplicativo"];
    }

    public function updateApplication($id, $name, $fileLink, $p2p, $orderBy, $rating, $size, $downloader, $ntdown, $description, $developer, $images)
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "UPDATE aplicativos 
                    SET name = :name, 
                        description = :description, 
                        developer = :developer, 
                        downloadsQuantity = :downloadsQuantity, 
                        rating = :rating, 
                        size = " . ($fileLink !== null ? ":size" : "size") . ", 
                        downloader = :downloader, 
                        ntdown = :ntdown, 
                        status = :status, 
                        p2p = :p2p, 
                        orderBy = :orderBy, 
                        imagens = :images" . 
                    ($fileLink !== null ? ", link = :fileLink" : "") . " 
                    WHERE id = :id";
                    
            $stmt = $PDO->prepare($sql);

            $params = [
                ':name' => $name,
                ':description' => $description,
                ':developer' => $developer,
                ':downloadsQuantity' => 0, // Valor padrão
                ':rating' => $rating,
                ':downloader' => $downloader,
                ':ntdown' => $ntdown,
                ':status' => 'Active', // Valor padrão
                ':p2p' => $p2p,
                ':orderBy' => $orderBy,
                ':images' => json_encode($images),
                ':id' => $id
            ];

            if ($fileLink !== null) {
                $params[':fileLink'] = $fileLink;
                $params[':size'] = $size;
            }

            if ($stmt->execute($params)) {
                return ["status" => true, "message" => "Aplicação atualizada com sucesso"];
            }
        }
        return ["status" => false, "message" => "Falha ao atualizar o aplicativo"];
    }

    public function deleteApplication($id)
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "DELETE FROM aplicativos WHERE id = :id";
            $stmt = $PDO->prepare($sql);
            $params = [':id' => intval($id)];
            if ($stmt->execute($params)) {
                return ["status" => true, "message" => "Aplicação excluída com sucesso"];
            }
        }
        return ["status" => false, "message" => "Falha ao excluir o aplicativo"];
    }

    public function updateStatus($id, $status)
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "UPDATE aplicativos SET status = :status WHERE id = :id";
            $stmt = $PDO->prepare($sql);
            $params = [
                ':id' => intval($id),
                ':status' => $status
            ];
            if ($stmt->execute($params)) {
                return ["status" => true, "message" => "Status do aplicativo atualizado com sucesso"];
            }
        }
        return ["status" => false, "message" => "Falha ao atualizar o status do aplicativo"];
    }

    // Novo método para atualizar a contagem de downloads
    public function updateDownloadCount($id)
    {
        $PDO = conexaoPDOlocal();

        if ($PDO !== NULL) {
            $sql = "UPDATE aplicativos 
                    SET downloadsQuantity = downloadsQuantity + 1 
                    WHERE id = :id;";
            $stmt = $PDO->prepare($sql);
            $params = [
                ':id' => intval($id)
            ];
            if ($stmt->execute($params)) {
                return ["status" => true, "message" => "Contagem de downloads atualizada com sucesso"];
            }
        }
        return ["status" => false, "message" => "Falha ao atualizar a contagem de downloads"];
    }
}
