<?php
include '../../configuracoes/functions.php';
include '../../../autoload.php';

// Define o cabeçalho para JSON
header('Content-Type: application/json');

// Verifica se os dados foram enviados via POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtém os dados do POST
    $id = $_POST['id'] ?? '';
    
    $senhaAntiga = $_POST['senhaAntiga'] ?? '';
    $novaSenha = $_POST['novaSenha'] ?? '';
    $novaSenhaConfirmacao = $_POST['novaSenhaConfirmacao'] ?? '';
    
    
    if (empty($id)) {
        echo json_encode(['status' => false, 'message' => 'ID do usuário é obrigatório.']); exit;
    }

    // Campos obrigatórios
    if (empty($senhaAntiga)) {
        echo json_encode(['status' => false, 'message' => 'Forneça a sua senha antiga']); exit;
    }
    if (empty($novaSenha)) {
        echo json_encode(['status' => false, 'message' => 'Forneça a nova senha']); exit;
    }
    if ($novaSenha !== $novaSenhaConfirmacao) {
        echo json_encode(['status' => false, 'message' => 'As senhas não são iguais.']); exit;
    }

   

    // Sanitização dos dados
    $senhaAntiga = htmlspecialchars(strip_tags($senhaAntiga));
    $novaSenha = htmlspecialchars(strip_tags($novaSenha));
    $novaSenhaConfirmacao = htmlspecialchars(strip_tags($novaSenhaConfirmacao));

    
    // Cria uma instância da classe Aplicativos
    $usuario = new Usuario();

    // Atualiza o aplicativo no banco de dados
    try {
        $result = $usuario->updatePassword(
            $id,
            $senhaAntiga,
            $novaSenha
        );
        echo json_encode($result); exit;
    } catch (Exception $e) {
        echo json_encode(['status' => false, 'message' => 'Erro ao atualizar a senha: ' . $e->getMessage()]); exit;
    }
}

echo json_encode(['status' => false, 'message' => 'Método de requisição inválido.']);