<?php
include '../../configuracoes/functions.php';
include '../../../autoload.php';

/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */


// Define o cabeçalho para JSON
header('Content-Type: application/json');

// Verifica se os dados foram enviados via POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtém os dados do POST
    $id = $_POST['id'] ?? '';
    $status = $_POST['status'] ?? '';

    // Validação dos dados
    if (empty($id)) {
        echo json_encode(['status' => false, 'message' => 'ID do aplicativo é obrigatório.']);
        exit;
    }
    if (!in_array($status, ['Active', 'Inactive'])) {
        echo json_encode(['status' => false, 'message' => 'Status inválido.']);
        exit;
    }

    // Sanitização do ID
    $id = intval($id);

    // Cria uma instância da classe Aplicativos
    $aplicativo = new Aplicativos();

    // Tenta atualizar o status do aplicativo
    try {
        $result = $aplicativo->updateStatus($id, $status);
        echo json_encode($result);
    } catch (Exception $e) {
        echo json_encode(['status' => false, 'message' => 'Erro ao atualizar o status do aplicativo: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => false, 'message' => 'Método de requisição inválido.']);
}
