<?php
include '../../configuracoes/functions.php';
include '../../../autoload.php';

/**
 * Desenvolvido por script php brasil
 * https://scriptphpbrasil.com.br
 */


// Define o cabeçalho para JSON
header('Content-Type: application/json');

// Verifica se os dados foram enviados via POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtém os dados do POST
    $id = $_POST['id'] ?? '';

    // Validação dos dados
    if (empty($id)) {
        echo json_encode(['status' => false, 'message' => 'ID do aplicativo é obrigatório.']);
        exit;
    }

    // Sanitização do ID
    $id = intval($id);

    // Cria uma instância da classe Aplicativos
    $aplicativo = new Aplicativos();

    // Tenta excluir o aplicativo do banco de dados
    try {
        $result = $aplicativo->deleteApplication($id);
        echo json_encode($result); exit;
    } catch (Exception $e) {
        echo json_encode(['status' => false, 'message' => 'Erro ao excluir o aplicativo: ' . $e->getMessage()]); exit;
    }
}

echo json_encode(['status' => false, 'message' => 'Método de requisição inválido.']);