<?php
    $file_path = 'a/note.json';
    $file_content = file_get_contents($file_path);
    $data_array = json_decode($file_content, true);
    $flash_message = '<div class="alert alert-primary" id="flash-msg"><h4><i class="icon fa fa-check"></i>Items Updated!</h4></div>';

    if (isset($_POST['text'])) {
        $new_data = ['title' => $_POST['title'], 'content' => $_POST['content']];
        $merged_data = array_replace_recursive($data_array, $new_data);
        $updated_content = json_encode($merged_data, JSON_UNESCAPED_UNICODE);
        file_put_contents($file_path, $updated_content);
        header('Location: note.php?m=' . $flash_message);
    }

    $title = $data_array['title'];
    $content = $data_array['content'];
    include 'includes/header.php';
?>
    <div class="container-fluid">
<?php
    if (isset($_GET['m'])) {
        echo $_GET['m'];
    }
?>
        <h1 class="h3 mb-1 text-gray-800">Notifications</h1>
        <!-- Content Row -->
        <div class="row">
            <!-- First Column -->
            <div class="col-lg-6">
                <!-- Custom codes -->
                <div class="card border-left-primary shadow h-100 card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary2"><i class="fa fa-bullhorn"></i> Send Notifications</h6>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <div class="form-group ">
                                <label class="control-label" for="title"><strong>Title:</strong></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="TITLE" name="title" value="<?= $title ?>">
                                </div>
                            </div>
                            <div class="form-group ">
                                <label class="control-label " for="content"><strong>Message:</strong></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="MESSAGE" name="content" value="<?= $content ?>">
                                </div>
                            </div>
                            <button type="submit" name="text" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
    include 'includes/footer.php';
?>
</body>
</html>
