<?php
// caminho do arquivo que armazena os comandos
$file = __DIR__ . '/commands.json';
$commands = [];
$msg = '';

// quando vier via POST, grava um novo comando
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cmd = trim($_POST['command'] ?? '');
    $pkg = trim($_POST['packageName'] ?? '');

    if ($cmd !== '' && $pkg !== '') {
        // limpa e grava apenas o novo comando
$commands = [[
    'status'      => 'success',
    'command'     => $cmd,
    'packageName' => $pkg
]];
        file_put_contents($file, json_encode($commands, JSON_PRETTY_PRINT));
        $msg = "Comando '{$cmd}' para pacote '{$pkg}' adicionado com sucesso.";
    } else {
        $msg = "Preencha ambos os campos.";
    }
}
?>

<?php include './includes/header.php'; ?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel de Comandos</title>
    <link href="https://cdn.jsdelivr.net/npm/font-awesome/css/font-awesome.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #ffffff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 2em;
            width: 100%;
            max-width: 400px;
        }
        h1 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }
        label {
            color: #555;
            margin-bottom: 8px;
            display: block;
        }
        input, select, button {
            width: 100%;
            padding: 12px;
            margin-bottom: 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #45a049;
        }
        .message {
            text-align: center;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .message.success {
            color: green;
        }
        .message.error {
            color: red;
        }
        select {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background: url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css') no-repeat;
            background-position: right center;
            background-size: 1.2em;
        }
        .command-icon {
            margin-right: 8px;
        }
    </style>
</head>
<body>

<div class="container">
<h1><i class="fa fa-times"></i> Enviar Comando</h1>


    <?php if ($msg): ?>
        <div class="message <?= strpos($msg, 'sucesso') !== false ? 'success' : 'error' ?>">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>

    <form method="post">
        <label for="packageName">Nome do pacote (packageName)</label>
        <input type="text" id="packageName" name="packageName" required />

        <label for="command">Comando</label>
        <select id="command" name="command" required>
            <option value="">— selecione —</option>
            <option value="uninstall"><i class="fa fa-trash command-icon"></i>Desinstalar</option>
            <!-- Adicione mais comandos com ícones aqui -->
        </select>

        <button type="submit"><i class="fa fa-send"></i> Enviar Comando</button>
    </form>
</div>

</body>
</html>

<?php include './includes/footer.php'; ?>
