<?php
// painel.php

if (isset($_GET['sucesso'])) {
    $message = "Aplicativo salvo com sucesso!";
}
?>

<?php include './includes/header.php'; ?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel MaxLauncher</title>
    <!-- Ícones do Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f2f5;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1 {
            color: #4A90E2;
            text-align: center;
            margin-top: 30px;
        }
        form {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            max-width: 500px;
            margin: 30px auto;
        }
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        .form-group input[type="text"],
        .form-group input[type="file"] {
            width: 100%;
            padding: 12px 40px 12px 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            transition: border-color 0.3s;
        }
        .form-group input:focus {
            border-color: #4A90E2;
            outline: none;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 600;
        }
        .form-group i {
            position: absolute;
            right: 15px;
            top: 40px;
            color: #aaa;
        }
        button {
            width: 100%;
            padding: 12px;
            background-color: #4A90E2;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #357ABD;
        }
        .message {
            margin: 20px auto;
            max-width: 500px;
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        @media (max-width: 600px) {
            form {
                padding: 20px;
                margin: 20px;
            }
            .message {
                margin: 20px;
            }
        }
    </style>
</head>
<body>

<h1><i class="fas fa-plus-circle"></i> Painel - Adicionar Aplicativo</h1>

<?php if (isset($message)) { echo "<div class='message'><i class='fas fa-check-circle'></i> {$message}</div>"; } ?>

<form method="POST" action="salvar_apps.php" enctype="multipart/form-data">
    <div class="form-group">
        <label>Nome do Aplicativo</label>
        <input type="text" name="name" placeholder="Ex: Youtube" required>
        <i class="fas fa-font"></i>
    </div>

    <div class="form-group">
        <label>Nome do Pacote (package)</label>
        <input type="text" name="package" placeholder="Ex: com.maxloja.xyz" required>
        <i class="fas fa-box"></i>
    </div>

    <div class="form-group">
        <label>Ícone do App (.png, .jpg)</label>
        <input type="file" name="icon_file" accept="image/*" required>
        <i class="fas fa-image"></i>
    </div>

    <div class="form-group">
        <label>Arquivo APK (.apk)</label>
        <input type="file" name="apk_file" accept=".apk" required>
        <i class="fas fa-file-archive"></i>
    </div>

    <button type="submit"><i class="fas fa-save"></i> Salvar Aplicativo</button>
</form>

<?php include './includes/footer.php'; ?>

</body>
</html>
