<?php include './includes/header.php'; ?>

<div class="logo-update-container">
    <h2><i class="fas fa-image"></i> Atualizar Logo</h2>

    <?php
    // Diretório das imagens
    $img_dir = "img/";
    // Caminho correto para o arquivo api.json
    $json_file = $img_dir . "api.json";

    // Detectar domínio automaticamente
    $domain = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";

    // Se o JSON não existir, cria com valores padrão
    if (!file_exists($json_file)) {
        $default_data = [
            "logo" => "$domain/img/logo1.jpg",
            "background" => "$domain/img/fundo_max.png"
        ];
        file_put_contents($json_file, json_encode($default_data, JSON_PRETTY_PRINT));
    }

    // Carrega os dados do JSON
    $json_data = json_decode(file_get_contents($json_file), true);
    $logo_url = $json_data['logo'];

    // Função para gerar nome sequencial de imagem
    function getNextLogoFilename($dir) {
        $i = 1;
        while (file_exists($dir . "logo$i.jpg")) {
            $i++;
        }
        return "logo$i.jpg";
    }

    // Upload da nova imagem
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmp_name = $_FILES['logo']['tmp_name'];
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) {
            $new_filename = getNextLogoFilename($img_dir);
            $target_path = $img_dir . $new_filename;

            if (move_uploaded_file($tmp_name, $target_path)) {
                $new_url = "$domain/$target_path";

                // Atualiza o JSON
                $json_data['logo'] = $new_url;

                // Tenta salvar o JSON e exibe mensagem de erro, se falhar
                if (file_put_contents($json_file, json_encode($json_data, JSON_PRETTY_PRINT))) {
                    echo "<div class='success-message'><i class='fas fa-check-circle'></i> Nova logo enviada e JSON atualizado com sucesso!</div>";
                    $logo_url = $new_url;
                } else {
                    echo "<div class='error-message'><i class='fas fa-exclamation-circle'></i> Erro ao atualizar o arquivo JSON.</div>";
                }
            } else {
                echo "<div class='error-message'><i class='fas fa-exclamation-circle'></i> Erro ao mover a imagem.</div>";
            }
        } else {
            echo "<div class='error-message'><i class='fas fa-exclamation-circle'></i> Tipo de arquivo inválido. Use jpg, jpeg, png ou gif.</div>";
        }
    }
    ?>

    <?php if (!empty($logo_url)): ?>
        <div class="current-logo-section">
            <p class="current-logo-label"><i class="fas fa-eye"></i> Logo atual:</p>
            <div class="logo-preview-container">
                <img src="<?= $logo_url ?>" alt="Logo atual" class="current-logo-image">
            </div>
        </div>
    <?php endif; ?>

    <div class="upload-form-container">
        <form method="post" enctype="multipart/form-data" class="logo-upload-form">
            <div class="form-group">
                <label for="logo" class="file-label"><i class="fas fa-file-image"></i> Escolher nova imagem:</label>
                <div class="file-input-container">
                    <input type="file" name="logo" id="logo" class="file-input" required>
                    <label for="logo" class="file-custom">
                        <i class="fas fa-cloud-upload-alt"></i>
                        <span>Selecionar arquivo</span>
                    </label>
                </div>
                <p class="file-hint"><i class="fas fa-info-circle"></i> Formatos aceitos: JPG, JPEG, PNG, GIF</p>
            </div>
            <button type="submit" class="submit-button">
                <i class="fas fa-upload"></i> Enviar Nova Logo
            </button>
        </form>
    </div>
</div>

<!-- Font Awesome para ícones -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<style>
    /* Estilos base */
    .logo-update-container {
        max-width: 800px;
        margin: 0 auto;
        padding: 30px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    h2 {
        color: #2c3e50;
        text-align: center;
        margin-bottom: 30px;
        font-size: 28px;
    }
    
    h2 i {
        margin-right: 10px;
        color: #3498db;
    }
    
    .current-logo-section {
        margin: 30px 0;
        text-align: center;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px dashed #ddd;
    }
    
    .current-logo-label {
        font-weight: bold;
        margin-bottom: 15px;
        color: #555;
        font-size: 18px;
    }
    
    .current-logo-label i {
        color: #3498db;
        margin-right: 8px;
    }
    
    .logo-preview-container {
        display: inline-block;
        padding: 10px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
    }
    
    .logo-preview-container:hover {
        transform: scale(1.03);
    }
    
    .current-logo-image {
        width: 150px;
        height: 150px;
        object-fit: contain;
        border: 1px solid #eee;
        border-radius: 4px;
        padding: 5px;
        background: white;
    }
    
    .upload-form-container {
        background: #f8f9fa;
        padding: 25px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        border: 1px solid #eee;
    }
    
    .logo-upload-form {
        display: flex;
        flex-direction: column;
        gap: 25px;
    }
    
    .form-group {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }
    
    .file-label {
        margin-bottom: 5px;
        font-weight: bold;
        color: #555;
        font-size: 16px;
    }
    
    .file-label i {
        color: #3498db;
        margin-right: 8px;
    }
    
    .file-input-container {
        position: relative;
    }
    
    .file-input {
        position: absolute;
        left: -9999px;
    }
    
    .file-custom {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 12px 20px;
        background: #3498db;
        color: white;
        border-radius: 6px;
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px dashed rgba(255,255,255,0.3);
    }
    
    .file-custom:hover {
        background: #2980b9;
        transform: translateY(-2px);
    }
    
    .file-custom i {
        margin-right: 10px;
        font-size: 18px;
    }
    
    .file-hint {
        font-size: 13px;
        color: #666;
        margin-top: 5px;
    }
    
    .file-hint i {
        color: #3498db;
        margin-right: 5px;
    }
    
    .submit-button {
        background-color: #2ecc71;
        color: white;
        padding: 14px 25px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-size: 16px;
        font-weight: bold;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    
    .submit-button:hover {
        background-color: #27ae60;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .submit-button:active {
        transform: translateY(0);
    }
    
    .submit-button i {
        font-size: 18px;
    }
    
    .success-message {
        color: #155724;
        background-color: #d4edda;
        border: 1px solid #c3e6cb;
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .success-message i {
        font-size: 20px;
    }
    
    .error-message {
        color: #721c24;
        background-color: #f8d7da;
        border: 1px solid #f5c6cb;
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .error-message i {
        font-size: 20px;
    }
    
    /* Responsividade */
    @media (max-width: 768px) {
        .logo-update-container {
            padding: 20px;
        }
        
        h2 {
            font-size: 24px;
        }
        
        .upload-form-container {
            padding: 20px;
        }
        
        .submit-button {
            padding: 12px 20px;
            font-size: 15px;
        }
    }
    
    @media (max-width: 480px) {
        .logo-update-container {
            padding: 15px;
        }
        
        .current-logo-image {
            width: 120px;
            height: 120px;
        }
        
        .file-custom {
            padding: 10px 15px;
            font-size: 14px;
        }
    }
</style>

<?php include './includes/footer.php'; ?>