<?php
// Verificar se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';

    // Validar o nome
    if (empty($name)) {
        exit;
    }

    $jsonPath = 'img/api.json';

    // Verificar se o arquivo JSON existe
    if (file_exists($jsonPath)) {
        $jsonData = file_get_contents($jsonPath);
        $dataArray = json_decode($jsonData, true);

        // Verificar se os dados do JSON são válidos
        if ($dataArray && isset($dataArray['data'][0])) {
            // Atualizar o nome
            $dataArray['data'][0]['name'] = $name;

            // Salvar as alterações no arquivo JSON
            if (file_put_contents($jsonPath, json_encode($dataArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
                header("Location: nomeapk.php");
                exit;
            } else {
                exit;
            }
        } else {
            exit;
        }
    } else {
        exit;
    }
} else {
    exit;
}
