<?php
require_once '../config/database.php';

try {
    // Busca usuários online (última conexão nos últimos 5 minutos)
    $stmt = $pdo->prepare("
        SELECT 
            device_id,
            device_model,
            last_connection,
            uptime,
            ip_address,
            (strftime('%s', 'now') - strftime('%s', last_connection)) < 300 AS is_online
        FROM user_connections
        ORDER BY last_connection DESC
    ");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'users' => $users]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>