<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔎 Busca de Renovação IPTV</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Estilos modernizados */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                        url('https://i.postimg.cc/SKZkjjZv/Inserir-um-t-tulo-16.png') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
        }

        .container {
            text-align: center;
            background-color: rgba(0, 0, 0, 0.8);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            width: 90%;
            max-width: 500px;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            animation: fadeIn 0.8s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .logo img {
            width: 120px;
            height: 120px;
            object-fit: contain;
            margin-bottom: 20px;
            transition: transform 0.3s;
        }

        .logo img:hover {
            transform: scale(1.05);
        }

        .message {
            margin: 20px 0;
            font-size: 18px;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            line-height: 1.6;
            padding: 15px;
            background-color: rgba(0, 123, 255, 0.2);
            border-radius: 8px;
            border-left: 4px solid #007bff;
        }

        .message i {
            margin-right: 12px;
            color: #4dabf7;
            font-size: 24px;
        }

        .search-box {
            margin-top: 25px;
        }

        .search-box form {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 15px;
        }

        .search-box input[type="text"] {
            padding: 12px 20px 12px 45px;
            font-size: 16px;
            border: 2px solid #007bff;
            border-radius: 30px;
            width: 100%;
            max-width: 400px;
            background: rgba(255, 255, 255, 0.1) url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/svgs/solid/search.svg') no-repeat 15px center;
            background-size: 20px;
            color: white;
            transition: all 0.3s;
        }

        .search-box input[type="text"]:focus {
            outline: none;
            border-color: #4dabf7;
            box-shadow: 0 0 0 3px rgba(77, 171, 247, 0.3);
            background-color: rgba(255, 255, 255, 0.2);
        }

        .search-box input[type="text"]::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .search-box button {
            padding: 14px 30px;
            font-size: 18px;
            width: 220px;
            color: #fff;
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            border: none;
            border-radius: 30px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.4);
        }

        .search-box button i {
            margin-right: 10px;
        }

        .search-box button:hover {
            background: linear-gradient(135deg, #0069d9 0%, #004a9f 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 123, 255, 0.6);
        }

        .search-box button:active {
            transform: translateY(0);
        }

        /* Responsividade */
        @media (max-width: 600px) {
            .container {
                padding: 20px;
                width: 95%;
            }
            
            .message {
                font-size: 16px;
                flex-direction: column;
                text-align: center;
            }
            
            .message i {
                margin-right: 0;
                margin-bottom: 10px;
            }
            
            .search-box input[type="text"] {
                width: 90%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="img/logo.png" alt="Logo IPTV">
        </div>
        <div class="message">
            <i class="fas fa-info-circle"></i>
            <span>📢 Olá! Para renovação do seu serviço IPTV, digite abaixo o usuário ou MAC Address fornecido pelo seu vendedor!</span>
        </div>
        <div class="search-box">
            <form action="search_results.php" method="GET">
                <input type="text" name="query" placeholder="🔍 Digite Username ou MAC Address..." required>
                <button type="submit"><i class="fas fa-sync-alt"></i> 🔄 Renovar</button>
            </form>
        </div>
    </div>

    <?php include('includes/footer.php'); ?>
</body>
</html>