<?php



// Inclui funes e inicia a sesso
include "includes/functions.php";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica se o usurio est logado
$log_check = $db->select("users", "*", "id = :id", "", [":id" => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]["username"] : NULL;
if (!empty($loggedinuser) && 
    isset($_SESSION["name"]) && 
    $_SESSION["name"] === $loggedinuser) {
    header("Location: dash.php");
    exit;
}

// Insere o usurio admin se no existir
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// Processa o login
$login_error = ""; // Varivel para mensagem de erro
if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData) {
        $storedPassword = $userData[0]["password"];
        if ($_POST["password"] === $storedPassword) {
            session_regenerate_id();
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $_POST["username"];
            header($_POST["username"] == "admin" ? "Location: user.php" : "Location: dash.php");
            exit;
        } else {
            $login_error = "Senha incorreta!";
        }
    } else {
        $login_error = "Usurio no encontrado!";
    }
    $db->close();
}

$file_name = './codigo_json.json';
$json_data = file_get_contents($file_name);

if ($json_data === false) {
    die("Erro ao ler o arquivo JSON.");
}

$data = json_decode($json_data, true);
$codigo = $data['codigo'];

// HTML da pgina
echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="author" content="MAXLOJA">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <title>MAXLOJA Aplicativos - Login</title>
    <style>
        :root {
            --dark-background: #231E3D;
            --form-background: #2E2849;
            --input-background: #3B3454;
            --input-border: #4A446B;
            --primary-green: #00E676;
            --text-light: #E0E0E0;
            --text-dark: #A0A0A0;
            --text-highlight: #A3E635;
            --error-color: #FF5252;
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: var(--dark-background);
            color: var(--text-light);
            overflow-x: hidden;
        }

        .login-container {
            display: flex;
            flex-direction: column;
            width: 100%;
            max-width: 100%;
            background-color: var(--dark-background);
            border-radius: 0;
            overflow: hidden;
            padding: 20px;
        }

        .left-section {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 20px 0;
            text-align: center;
            width: 100%;
        }

        .left-section h1 {
            font-size: 1.8rem;
            color: var(--text-light);
            margin-bottom: 20px;
            font-weight: 600;
            line-height: 1.3;
            padding: 0 15px;
        }

        .left-section .astronaut-img {
            max-width: 70%;
            height: auto;
            margin-top: 20px;
        }

        .right-section {
            width: 100%;
            background-color: var(--form-background);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 20px;
        }

        .right-section h2 {
            font-size: 1.5rem;
            color: var(--primary-green);
            margin-bottom: 25px;
            font-weight: 700;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .error-message {
            color: var(--error-color);
            background-color: rgba(255, 82, 82, 0.1);
            padding: 10px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            width: 100%;
            text-align: center;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .form-group {
            width: 100%;
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            font-size: 0.9rem;
            color: var(--text-light);
            margin-bottom: 8px;
            font-weight: 500;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid var(--input-border);
            border-radius: 8px;
            background-color: var(--input-background);
            color: var(--text-light);
            font-size: 1rem;
            outline: none;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        .form-control::placeholder {
            color: var(--text-dark);
            opacity: 0.8;
        }

        .form-control:focus {
            border-color: var(--primary-green);
            box-shadow: 0 0 0 3px rgba(0, 230, 118, 0.2);
        }

        .btn-login {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 8px;
            background-color: var(--primary-green);
            color: var(--dark-background);
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
            margin-top: 15px;
        }

        .btn-login:hover {
            background-color: #00C853;
            transform: translateY(-2px);
        }

        .btn-download-app {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--primary-green);
            border-radius: 8px;
            background-color: transparent;
            color: var(--primary-green);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease, color 0.3s ease, transform 0.2s ease;
            margin-top: 15px;
            text-align: center;
            text-decoration: none;
            display: block;
        }

        .btn-download-app:hover {
            background-color: rgba(0, 230, 118, 0.1);
            color: var(--primary-green);
            transform: translateY(-2px);
        }

        /* Media Queries para telas maiores */
        @media (min-width: 768px) {
            .login-container {
                flex-direction: row;
                max-width: 900px;
                padding: 40px;
                border-radius: 20px;
            }

            .left-section {
                flex: 1;
                align-items: flex-start;
                text-align: left;
                padding-right: 40px;
            }

            .left-section h1 {
                font-size: 2rem;
                padding: 0;
            }

            .left-section .astronaut-img {
                max-width: 90%;
                margin-top: 30px;
            }

            .right-section {
                flex: 0.7;
                margin-top: 0;
                padding: 30px;
            }

            .right-section h2 {
                font-size: 1.8rem;
            }
        }

        @media (min-width: 992px) {
            .left-section h1 {
                font-size: 2.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="left-section">
            <h1>Faa login para entrar para o nosso time</h1>
            <img src="./img/logo.png" alt="Gato Astronauta" class="astronaut-img">
        </div>

        <div class="right-section">
            <h2>LOGIN</h2>
HTML;

// Exibe mensagem de erro se existir
if (!empty($login_error)) {
    echo '<div class="error-message">' . htmlspecialchars($login_error) . '</div>';
}

echo <<<HTML
            <form method="post">
                <div class="form-group">
                    <label for="username">Usurio</label>
                    <input type="text" id="username" class="form-control" placeholder="Usurio" name="username" required autofocus>
                </div>
                <div class="form-group">
                    <label for="password">Senha</label>
                    <input type="password" id="password" class="form-control" placeholder="Senha" name="password" required>
                </div>
                <input type="submit" class="btn-login" value="LOGIN" name="login">
                <a class="btn-download-app" href="./meu/new_ibo_app.apk" download>Baixar Aplicativo</a>
            </form>
        </div>
    </div>
</body>
</html>
HTML;
?>