<?php

ini_set('display_errors', 0);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db');
$adb = new SQLite3('./api/studiolivecode.db'); // Duplicado, verificar se é intencional
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

// Assumo que $db está sendo definido em functions.php ou em algum lugar antes.
// Se não estiver, esta linha pode gerar um erro.
$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Painel IBO">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<!-- jQuery (necessário para algumas versões do Bootstrap) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Bootstrap JS Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link href="css/simple-sidebar.css" rel="stylesheet">

    <style>
        body {
            /* Alterado para cinza grafite */
            background-color: #343a40; 
            /* Removido o background-image para um fundo liso */
            /* background-image: url("./img/binding_dark.webp"); */ 
            color: #f8f9fa; /* Cor do texto padrão para contraste */
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Sidebar styling with blue gradient */
        #sidebar-wrapper {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            min-height: 100vh;
            margin-left: -15rem;
            transition: margin .25s ease-out;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        }

        .sidebar-heading {
            padding: 1.5rem 1.5rem 0.5rem;
            font-size: 1.2rem;
            font-weight: bold;
            color: white;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 1rem;
        }

        .list-group-item {
            background-color: transparent;
            border: none;
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 20px;
            margin: 2px 0;
            transition: all 0.3s;
        }

        .list-group-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            text-decoration: none;
        }

        /* Icon animations */
        .list-group-item i {
            width: 24px;
            text-align: center;
            margin-right: 10px;
            transition: all 0.3s ease;
            display: inline-block;
        }

        /* Pulsing animation for important icons */
        .fa-server, .fa-exchange-alt, .fa-user-cog, .fa-ad {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.15); opacity: 0.8; }
            100% { transform: scale(1); opacity: 1; }
        }

        /* Swing animation on hover */
        .list-group-item:hover i {
            animation: swing 0.6s ease;
        }

        @keyframes swing {
            15% { transform: rotate(10deg); }
            30% { transform: rotate(-10deg); }
            50% { transform: rotate(5deg); }
            65% { transform: rotate(-5deg); }
            80% { transform: rotate(2deg); }
            100% { transform: rotate(0); }
        }

        /* Floating animation for special icons */
        .fa-robot, .fa-qrcode {
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {
            0% { transform: translateY(0); }
            50% { transform: translateY(-5px); }
            100% { transform: translateY(0); }
        }

        /* Glowing effect for active item */
        .list-group-item.active i {
            text-shadow: 0 0 8px rgba(255, 255, 255, 0.8);
        }

        .list-group-item-action:focus {
            background-color: rgba(255, 255, 255, 0.15);
            color: white;
        }

        /* Copyright section */
        .sidebar-footer {
            padding: 10px 20px;
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
        }

        /* Main content area */
        #page-content-wrapper {
            min-width: 100vw;
            /* Alterado para cinza grafite, correspondendo ao body */
            background-color: #343a40; 
        }

        /* Navbar styling */
        .navbar {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 0.5rem 1rem;
        }

        .navbar-dark .navbar-brand {
            color: white;
        }

        /* Particles JS container */
        #js-particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }

        /* Modal styling */
        .modal-content {
            background-color: #2a2a3a;
            color: white;
            border: none;
            border-radius: 8px;
        }

        .modal-header {
            border-bottom: 1px solid #3a3a4a;
        }

        .modal-footer {
            border-top: 1px solid #3a3a4a;
        }

        .close {
            color: white;
            opacity: 0.8;
        }

        /* Dropdown items in modal */
        .dropdown-item {
            color: rgba(255, 255, 255, 0.8);
            padding: 10px 20px;
            transition: all 0.3s;
        }

        .dropdown-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
        }

        /* Alert messages */
        #pageMessages {
            left: 50%;
            transform: translateX(-50%);
            position: fixed;
            text-align: center;
            top: 5px;
            width: 60%;
            z-index: 9999;
            border-radius: 4px;
        }

        .alert {
            position: relative;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .alert .close {
            position: absolute;
            top: 5px;
            right: 5px;
            font-size: 1em;
            color: inherit;
        }

        .alert .fa {
            margin-right: .3em;
        }

        /* Button animations */
        .btn {
            transition: all 0.3s ease;
            transform: translateY(0);
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .btn:active {
            transform: translateY(1px);
        }

        /* Responsive adjustments */
        @media (min-width: 768px) {
            #sidebar-wrapper {
                margin-left: 0;
            }
            
            #page-content-wrapper {
                min-width: 0;
                width: 100%;
            }
        }

        /* Adições para melhorar o contraste e a aparência no novo fundo */
        .container-fluid {
            color: #f8f9fa; /* Garante que o texto dentro do container seja claro */
        }

        /* Se houver cards com fundo branco ou claro, ajuste o texto */
        .card {
            background-color: #ffffff; /* Garante que os cards internos sejam brancos */
            color: #212529; /* Cor do texto para o card para contraste */
        }
        .card-header, .card-footer {
            color: #212529; /* Cor do texto para cabeçalhos e rodapés de card */
        }
        /* Ajuste a cor dos rótulos de formulário dentro de cards, se necessário */
        .card .form-control-color {
            border: 1px solid #ced4da; /* Adiciona borda aos seletores de cor */
        }
        .card label {
            color: #495057; /* Cor para rótulos dentro dos cards */
        }
        .card .text-muted {
            color: #6c757d !important; /* Cor para textos muted dentro dos cards */
        }
        
    </style>
</head>
<body>
<div id="js-particles"></div>

<div class="d-flex" id="wrapper">
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">IBO Player MaxRebrands</div>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="dash.php">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fas fa-server"></i> Servidores de DNS
            </a>

            <a class="list-group-item list-group-item-action" href="playlists.php">
                <i class="fas fa-users animate__animated animate__fadeIn"></i> Usuários conectados
            </a>
            <a class="list-group-item list-group-item-action" href="cadastrar_codigo.php">
                <i class="fas fa-code animate__animated animate__fadeIn"></i> Cadastrar Códigos
            </a>
            <a class="list-group-item list-group-item-action" href="ads.php">
                <i class="fas fa-ad"></i> Enviar de Anúncio
            </a>
            <a class="list-group-item list-group-item-action" href="ads2.php">
                <i class="fas fa-ad"></i> Enviar de Anúncio 02
            </a>
            <a class="list-group-item list-group-item-action" href="mRTXAdsSetting.php">
                <i class="fas fa-cog animate__animated animate__rotateIn"></i> Autoads/Manual
            </a>
            <a class="list-group-item list-group-item-action" href="themes.php">
                <i class="fas fa-palette animate__animated animate__rotateIn"></i> Selecionar Tema
            </a>      
            <a class="list-group-item list-group-item-action" href="settings.php">
                <i class="fas fa-comment-alt"></i> Mensagem Servers
            </a>
            <a class="list-group-item list-group-item-action" href="#" data-toggle="modal" data-target="#customizeModal">
                <i class="fas fa-paint-brush"></i> Personalizar App
                <i class="fas fa-chevron-down float-right"></i>
            </a>
            <a class="list-group-item list-group-item-action" href="chatbot.php">
                <i class="fas fa-robot"></i> Teste Automático
            </a>
<a class="list-group-item list-group-item-action" href="alterar_package.php">
    <i class="fas fa-qrcode"></i> Config Qrcode RN
</a>


            <a class="list-group-item list-group-item-action" href="pagamento.php">
                <i class="fas fa-money-bill-wave animate__animated animate__tada"></i> Pagamento
            </a>
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fas fa-user-cog"></i> Meu Perfil
            </a>
        </div>
        <div class="sidebar-footer">
            <a href="https://t.me/maxrebrands" target="_blank" style="color: rgba(255, 255, 255, 0.6);">
                © <?=date("Y")?> IBO Pro MaxRebrands
            </a>
        </div>
    </div>
    <div class="modal fade" id="customizeModal" tabindex="-1" role="dialog" aria-labelledby="customizeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="customizeModalLabel">Personalizar</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <a class="dropdown-item" href="bg.php">
                        <i class="fas fa-image animate__animated animate__fadeInLeft"></i> Mudar Fundo
                    </a>
                    <a class="dropdown-item" href="logo.php">
                        <i class="fas fa-image animate__animated animate__fadeInLeft"></i> Mudar Logo
                    </a>
                    <a class="dropdown-item" href="ajustescores.php">
                        <i class="fas fa-palette animate__animated animate__fadeInLeft"></i> Cores botões
                    </a>

                    <a class="dropdown-item" href="edit_texto.php">
                        <i class="fas fa-envelope animate__animated animate__fadeInLeft"></i> Enviar Mensagem
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <button class="btn btn-primary" id="menu-toggle">
                <img src="img/logo.png" width="25" height="25" class="d-inline-block align-top" alt="">
            </button>
            <div class="center" id="pageMessages"></div>
            <a href="logout.php" class="btn btn-danger ml-auto animate__animated animate__pulse">Logout</a>
        </nav>
        <div class="container-fluid"><br>