<?php
ini_set("display_errors", 1);
error_reporting(E_ALL);

include "includes/header.php";

$adb = new SQLite3('./api/studiolivecode.db');

// Criação das tabelas com a estrutura correta
$adb->exec("CREATE TABLE IF NOT EXISTS codes (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    dns_id INTEGER NOT NULL,
    code TEXT NOT NULL,
    m3u_url TEXT NOT NULL,
    FOREIGN KEY (dns_id) REFERENCES dns(id)
)");

$adb->exec("CREATE TABLE IF NOT EXISTS dns (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    title TEXT NOT NULL,
    url TEXT NOT NULL
)");

// Processamento dos formulários
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
    $codigo = trim($_POST['codigo'] ?? '');
    $m3u_url = trim($_POST['m3u_url'] ?? '');
    $dns_id = $_POST['dns_id'] ?? null;

    if (empty($codigo) || empty($m3u_url) || empty($dns_id)) {
        echo "<div class='alert alert-danger'>⚠️ Preencha todos os campos.</div>";
    } else {
        // Verifica se já existe um código IDÊNTICO para este DNS
        $stmt = $adb->prepare("SELECT COUNT(*) FROM codes WHERE dns_id = :dns_id AND code = :code");
        $stmt->bindValue(':dns_id', $dns_id, SQLITE3_INTEGER);
        $stmt->bindValue(':code', $codigo, SQLITE3_TEXT);
        $exists = $stmt->execute()->fetchArray()[0];

        if ($exists) {
            echo "<div class='alert alert-warning'>⚠️ Já existe um código IDÊNTICO cadastrado para esta Conexão DNS.</div>";
        } else {
            $stmt = $adb->prepare("INSERT INTO codes (dns_id, code, m3u_url) VALUES (:dns_id, :code, :m3u_url)");
            $stmt->bindValue(':dns_id', $dns_id, SQLITE3_INTEGER);
            $stmt->bindValue(':code', $codigo, SQLITE3_TEXT);
            $stmt->bindValue(':m3u_url', $m3u_url, SQLITE3_TEXT);

            if ($stmt->execute()) {
                echo "<div class='alert alert-success'>✅ Código cadastrado com sucesso!</div>";
            } else {
                echo "<div class='alert alert-danger'>⚠️ Erro ao cadastrar código.</div>";
            }
        }
    }
    break;

            case 'edit':
                $id = $_POST['id'] ?? null;
                $new_m3u_url = trim($_POST['new_m3u_url'] ?? '');

                if (empty($id) || empty($new_m3u_url)) {
                    echo "<div class='alert alert-danger'>⚠️ Dados inválidos para edição.</div>";
                } else {
                    $stmt = $adb->prepare("UPDATE codes SET m3u_url = :m3u_url WHERE id = :id");
                    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
                    $stmt->bindValue(':m3u_url', $new_m3u_url, SQLITE3_TEXT);

                    if ($stmt->execute()) {
                        echo "<div class='alert alert-success'>✅ URL M3U atualizada com sucesso!</div>";
                    } else {
                        echo "<div class='alert alert-danger'>⚠️ Erro ao atualizar URL M3U.</div>";
                    }
                }
                break;

            case 'delete':
                $id = $_POST['id'] ?? null;
                
                if (empty($id)) {
                    echo "<div class='alert alert-danger'>⚠️ ID inválido para exclusão.</div>";
                } else {
                    $stmt = $adb->prepare("DELETE FROM codes WHERE id = :id");
                    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
                    
                    if ($stmt->execute()) {
                        echo "<div class='alert alert-success'>🗑️ Código deletado com sucesso!</div>";
                    } else {
                        echo "<div class='alert alert-danger'>⚠️ Erro ao deletar código.</div>";
                    }
                }
                break;
        }
    }
}

// Buscar conexões DNS
$dns_connections = [];
$result = $adb->query("SELECT id, title FROM dns ORDER BY title ASC");
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    $dns_connections[] = $row;
}

// Buscar códigos cadastrados
$codigos = [];
$result = $adb->query("
    SELECT c.id, c.dns_id, c.code, c.m3u_url, d.title AS dns_title 
    FROM codes c 
    JOIN dns d ON c.dns_id = d.id 
    ORDER BY c.id DESC
");
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    $codigos[] = $row;
}
?>

<div class="container">
    <h2 class="text-center my-4">📝 Cadastro de Código M3U</h2>
    
    <div class="card mb-4">
        <div class="card-header bg-dark text-white">
            <h4 class="mb-0">➕ Adicionar Novo Código</h4>
        </div>
        <div class="card-body">
            <form method="post">
                <input type="hidden" name="action" value="add">
                
                <div class="form-group">
                    <label>🔑 Código:</label>
                    <input type="text" class="form-control" name="codigo" required>
                </div>
                
                <div class="form-group">
                    <label>🔗 URL M3U:</label>
                    <textarea class="form-control" name="m3u_url" rows="3" required></textarea>
                </div>
                
                <div class="form-group">
                    <label>🌐 Conexão DNS:</label>
                    <select class="form-control" name="dns_id" required>
                        <option value="">Selecione uma Conexão DNS</option>
                        <?php foreach ($dns_connections as $dns): ?>
                            <option value="<?= htmlspecialchars($dns['id']) ?>">
                                <?= htmlspecialchars($dns['title']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-danger btn-block mt-3">💾 Cadastrar Código</button>
            </form>
        </div>
    </div>

    <?php if (!empty($codigos)): ?>
        <div class="card">
            <div class="card-header bg-dark text-white">
                <h4 class="mb-0">📋 Códigos Cadastrados</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-dark table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>#️⃣ ID</th>
                                <th>🔑 Código</th>
                                <th>🔗 URL M3U</th>
                                <th>🌐 Conexão DNS (ID: <?= $c['dns_id'] ?>)</th>
                                <th>⚙️ Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($codigos as $c): ?>
                                <tr>
                                    <td><?= htmlspecialchars($c['id']) ?></td>
                                    <td><?= htmlspecialchars($c['code']) ?></td>
                                    <td style="word-break: break-all;"><?= htmlspecialchars($c['m3u_url']) ?></td>
                                    <td><?= htmlspecialchars($c['dns_title']) ?> (ID: <?= htmlspecialchars($c['dns_id']) ?>)</td>
                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-warning" data-toggle="modal" data-target="#editModal<?= $c['id'] ?>">
                                                ✏️ Editar
                                            </button>
                                            <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal<?= $c['id'] ?>">
                                                🗑️ Deletar
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Modal de Edição -->
                                <div class="modal fade" id="editModal<?= $c['id'] ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content bg-dark">
                                            <div class="modal-header">
                                                <h5 class="modal-title">✏️ Editar URL M3U</h5>
                                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                            </div>
                                            <form method="post">
                                                <div class="modal-body">
                                                    <input type="hidden" name="action" value="edit">
                                                    <input type="hidden" name="id" value="<?= $c['id'] ?>">
                                                    
                                                    <div class="form-group">
                                                        <label>🔗 Nova URL M3U:</label>
                                                        <textarea class="form-control" name="new_m3u_url" rows="5" required><?= htmlspecialchars($c['m3u_url']) ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">❌ Cancelar</button>
                                                    <button type="submit" class="btn btn-primary">💾 Salvar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Modal de Exclusão -->
                                <div class="modal fade" id="deleteModal<?= $c['id'] ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content bg-dark">
                                            <div class="modal-header">
                                                <h5 class="modal-title">🗑️ Confirmar Exclusão</h5>
                                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                            </div>
                                            <form method="post">
                                                <div class="modal-body">
                                                    <p>Tem certeza que deseja deletar o código <strong><?= htmlspecialchars($c['code']) ?></strong>?</p>
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="id" value="<?= $c['id'] ?>">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">❌ Cancelar</button>
                                                    <button type="submit" class="btn btn-danger">🗑️ Confirmar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php include "includes/footer.php"; ?>