<?php include 'includes/header.php'; ?>

<?php
// alterar_package.php

// Verifica se o formulário foi submetido
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['novo_package'])) {
    // Configurações
    $configFile = __DIR__ . '/config_package.php';
    $novoPackage = trim($_POST['novo_package']);
    
    // Validação básica
    if (!empty($novoPackage) && preg_match('/^[a-z][a-z0-9_]*(\.[a-z][a-z0-9_]*)+$/', $novoPackage)) {
        // Conteúdo do novo arquivo de configuração
        $configContent = "<?php\n// Arquivo atualizado automaticamente em " . date('d/m/Y H:i:s') . 
                       "\nreturn [\n    'package_name' => '" . addslashes($novoPackage) . "'\n];";
        
        // Tenta salvar o arquivo
        if (file_put_contents($configFile, $configContent)) {
            $mensagem = [
                'texto' => "🎉 Package alterado com sucesso para: <strong>$novoPackage</strong>",
                'tipo' => 'sucesso'
            ];
        } else {
            $mensagem = [
                'texto' => "⚠️ Erro ao salvar o novo package. Verifique as permissões do arquivo.",
                'tipo' => 'erro'
            ];
        }
    } else {
        $mensagem = [
            'texto' => "❌ Formato de package inválido. Use o formato: com.exemplo.app (apenas letras minúsculas, números e pontos)",
            'tipo' => 'erro'
        ];
    }
}

// Obtém o package atual
$config = @include __DIR__ . '/config_package.php';
$packageAtual = $config['package_name'] ?? 'com.flextv.dksystem';
?>

<div class="container py-5">
    <div class="card shadow-lg">
        <div class="card-header bg-primary text-white">
            <h1 class="h4 mb-0">📦 Alterar Package do Aplicativo</h1>
        </div>
        
        <div class="card-body">
            <?php if (isset($mensagem)): ?>
                <div class="alert alert-<?php echo $mensagem['tipo'] === 'sucesso' ? 'success' : 'danger'; ?> alert-dismissible fade show">
                    <?php echo $mensagem['texto']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <!-- Mensagem de alerta melhorada -->
            <div class="alert alert-info d-flex align-items-center mb-4">
                <div class="me-3">
                    <i class="bi bi-info-circle-fill fs-3"></i>
                </div>
                <div>
                    <h5 class="alert-heading mb-2">📌 Atenção!</h5>
                    <p class="mb-1">Esta página é <strong>exclusiva para configuração do pacote</strong> do aplicativo.</p>
                    <p class="mb-0">Após cadastrar com sucesso, o aplicativo <strong>reiniciará automaticamente</strong> para aplicar as alterações.</p>
                </div>
            </div>
            
            <div class="mb-4">
                <h2 class="h6 text-muted">🔍 Package Atual:</h2>
                <div class="p-3 bg-light rounded">
                    <code class="fs-5 text-primary"><?php echo htmlspecialchars($packageAtual); ?></code>
                </div>
            </div>
            
            <form method="POST" action="" class="needs-validation" novalidate>
                <div class="mb-3">
                    <label for="novo_package" class="form-label">✨ Novo Package:</label>
                    <input type="text" class="form-control form-control-lg" id="novo_package" name="novo_package" 
                           placeholder="Ex: com.novo.app" required
                           pattern="[a-z][a-z0-9_]*(\.[a-z][a-z0-9_]*)+"
                           title="Formato: com.exemplo.app (letras minúsculas, números e pontos)">
                    <div class="invalid-feedback">
                        Por favor, insira um package válido no formato com.exemplo.app
                    </div>
                    <div class="form-text mt-1">
                        ℹ️ O Novo Package deve ser igual ao do app original.
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary btn-lg w-100">
                    💾 Salvar Alterações
                </button>
            </form>
        </div>
        
        <div class="card-footer bg-light">
            <div class="accordion" id="infoAccordion">
                <div class="accordion-item border-0">
                    <h2 class="accordion-header" id="headingInfo">
                        <button class="accordion-button collapsed bg-light text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#collapseInfo" aria-expanded="false" aria-controls="collapseInfo">
                            📌 Mais Informações
                        </button>
                    </h2>
                    <div id="collapseInfo" class="accordion-collapse collapse" aria-labelledby="headingInfo" data-bs-parent="#infoAccordion">
                        <div class="accordion-body bg-light">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item bg-light text-secondary">✅ O package deve seguir o formato Android válido (ex: com.dominio.app)</li>
                                <li class="list-group-item bg-light text-secondary">✅ Use apenas letras minúsculas, números e pontos</li>
                                <li class="list-group-item bg-light text-secondary">❌ Não use espaços ou caracteres especiais</li>
                                <li class="list-group-item bg-light text-secondary">⚠️ Esta alteração afetará imediatamente o sistema de cadastro</li>
                                <li class="list-group-item bg-light text-secondary">🔄 O app reiniciará automaticamente após cadastro bem-sucedido</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Validação do formulário
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();
</script>

<?php include 'includes/footer.php'; ?>