<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Movie Banner</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            /* Removido o background-image */
            background-color: #000; /* Pode ser uma cor sólida ou outra imagem */
        }

        .banner-container {
            width: 100%;
            height: 100vh;
            display: flex;
            justify-content: flex-start; /* Inicia a rolagem à esquerda */
            align-items: center;
            overflow: hidden;
            position: relative;
        }

        .movie-poster-wrapper {
            display: flex;
            animation: rollMovies 130s linear infinite; /* Aumentado o tempo para tornar a rolagem mais lenta */
        }

        .movie-poster {
            width: 250px;
            height: 400px; /* Tamanho ajustável do pôster */
            margin-right: 10px;
            object-fit: cover; /* Ajusta as imagens para preencher o espaço */
        }

        @keyframes rollMovies {
            0% {
                transform: translateX(0); /* Começa na posição inicial */
            }
            100% {
                transform: translateX(-100%); /* Move o carrossel para a esquerda */
            }
        }
    </style>
</head>
<body>
    <div class="banner-container" id="movie-banner">
        <!-- Pôsteres dos filmes serão adicionados aqui -->
        <div class="movie-poster-wrapper" id="movie-posters">
            <!-- Filmes serão inseridos dinamicamente aqui -->
        </div>
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Sua chave da API do TMDb
        let movieIds = [];

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en-US`);
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
                updateMovieBanner(); // Atualizar o banner quando os filmes forem carregados
            } catch (error) {
                console.error(error);
            }
        }

        async function updateMovieBanner() {
            if (movieIds.length === 0) {
                console.error('Não foi possível carregar os IDs dos filmes.');
                return;
            }

            const moviePosterWrapper = document.getElementById('movie-posters');
            for (const movieId of movieIds) {
                try {
                    const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}`);
                    const data = await response.json();
                    const posterPath = `https://image.tmdb.org/t/p/original${data.poster_path}`;
                    const moviePoster = document.createElement('img');
                    moviePoster.src = posterPath;
                    moviePoster.alt = data.title;
                    moviePoster.className = 'movie-poster';
                    moviePosterWrapper.appendChild(moviePoster);
                } catch (error) {
                    console.error(error);
                }
            }
        }

        fetchPopularMovieIds();
    </script>
</body>
</html>
