<?php
// Verificação de requisições sem JavaScript (usando cookie ou token)
function verificarJavaScript() {
    if (!isset($_COOKIE['jsenabled'])) {
        echo "<script>document.cookie = 'jsenabled=true'; location.reload();</script>";
        exit();
    }
}

// Pequeno atraso para bloquear bots rápidos
function aplicarAtraso() {
    usleep(500000); // 0.5 segundos
}

// Executar verificações
bloquearUserAgent();
verificarCabecalhos();
verificarJavaScript();
aplicarAtraso();

// Verificação de domínio autorizado
if (!isset($_SERVER['HTTP_HOST']) || $_SERVER['HTTP_HOST'] !== $dominioAutorizado) {
    exibirPaginaBloqueio();
}

// Função para codificar os URLs das imagens
function codificarURL($url) {
    return base64_encode($url);
}

// Função para decodificar os URLs das imagens
function decodificarURL($urlCodificado) {
    return base64_decode($urlCodificado);
}

// Se um link oculto para imagem for acessado, redirecionar para a URL real
if (isset($_GET['img'])) {
    $url = decodificarURL($_GET['img']);
    header("Location: $url");
    exit;
}

// Função para gerar JavaScript para decodificação de imagens
function gerarScriptDecodificacao($imagens) {
    $script = "<script>\n";
    $script .= "document.addEventListener('DOMContentLoaded', function() {\n";
    foreach ($imagens as $id => $codificado) {
        $script .= "  document.getElementById('$id').src = atob('$codificado');\n";
    }
    $script .= "});\n";
    $script .= "</script>\n";
    return $script;
}

// Gerar um array para armazenar as imagens e seus IDs
$imagens = [];
$contadorImg = 0;

// Função para substituir src de img e adicionar ao array
function ocultarLinksDeImagensNoHTML($html) {
    global $imagens, $contadorImg;
    return preg_replace_callback(
        '/src=["\'](https:\/\/.*?)["\']/i',
        function($matches) use (&$imagens, &$contadorImg) {
            $urlCodificado = codificarURL($matches[1]);
            $idImagem = 'img' . $contadorImg++;
            $imagens[$idImagem] = $urlCodificado;
            return 'id="' . $idImagem . '" src="#"';
        },
        $html
    );
}

// Iniciar o buffer de saída
ob_start();

// Configurar o timezone
date_default_timezone_set('America/Sao_Paulo');

// Carregar o arquivo JSON com jogos
$jsonData = file_get_contents('jogos_do_dia.json');
$jogos = json_decode($jsonData, true);

// Obter a data atual
$diaSemana = array(
    'Sunday' => 'Domingo',
    'Monday' => 'Segunda-feira',
    'Tuesday' => 'Terça-feira',
    'Wednesday' => 'Quarta-feira',
    'Thursday' => 'Quinta-feira',
    'Friday' => 'Sexta-feira',
    'Saturday' => 'Sábado'
);
$meses = array(
    'January' => 'Janeiro',
    'February' => 'Fevereiro',
    'March' => 'Março',
    'April' => 'Abril',
    'May' => 'Maio',
    'June' => 'Junho',
    'July' => 'Julho',
    'August' => 'Agosto',
    'September' => 'Setembro',
    'October' => 'Outubro',
    'November' => 'Novembro',
    'December' => 'Dezembro'
);

$data = new DateTime();
$diaSemanaPort = $diaSemana[$data->format('l')];
$dia = $data->format('d');
$mesPort = $meses[$data->format('F')];
$dataAtual = "$diaSemanaPort, $dia de $mesPort";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jogos do Dia</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .logo {
            max-width: 300px;
            margin-bottom: 20px;
        }
        .jogos-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            width: 100%;
            max-width: 1200px;
        }
        .jogo-card {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 15px;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
        }
        .jogo-card h1 {
            font-size: 16px;
            color: #004080;
            margin-bottom: 5px;
        }
        .campeonato {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            margin-bottom: 15px;
        }
        .jogo-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            margin-bottom: 10px;
            position: relative;
        }
        .time {
            display: flex;
            align-items: center;
            flex-direction: column;
        }
        .time img {
            width: 80px;
            height: auto;
            margin-bottom: 5px;
            object-fit: contain;
        }
        .time-nome {
            font-weight: bold;
            font-size: 16px;
            color: #333;
            text-align: center;
        }
        .vs-hora-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .vs img {
            width: 140px;
            max-width: 100px;
            height: auto;
            object-fit: contain;
        }
        .hora {
            font-size: 20px;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            margin-top: 5px;
        }
        .canal {
            display: flex;
            justify-content: center;
            align-items: flex-end;
            flex-wrap: wrap;
            margin-top: auto;
            margin-bottom: 10px;
        }
        .canal img {
            width: 80px;
            height: auto;
            margin: 0 5px;
            object-fit: contain;
        }
        .transmissao {
            color: #d9534f;
            font-weight: bold;
            margin-top: 15px;
        }
        .mensagem-aviso {
            font-size: 16px; /* Aumentar o tamanho da fonte */
            font-weight: bold;
            color: white; /* Cor branca */
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<img src="https://i.imgur.com/ZkAc2hy.png" alt="Logo" class="logo">

<div class="jogos-container">
    <?php foreach ($jogos as $jogo): ?>
        <div class="jogo-card">
            <h1><?php echo $dataAtual; ?></h1>
            <div class="campeonato"><?php echo htmlspecialchars($jogo['campeonato']); ?></div>
            <div class="jogo-info">
                <div class="time">
                    <img src="<?php echo htmlspecialchars($jogo['logo1']); ?>" alt="<?php echo htmlspecialchars($jogo['time1']); ?> Logo">
                    <div class="time-nome"><?php echo htmlspecialchars($jogo['time1']); ?></div>
                </div>
                <div class="vs-hora-container">
                    <div class="vs">
                        <img src="https://i.imgur.com/WcT6FXq.png" alt="Versus">
                    </div>
                    <div class="hora"><?php echo htmlspecialchars($jogo['hora']); ?></div>
                </div>
                <div class="time">
                    <img src="<?php echo htmlspecialchars($jogo['logo2']); ?>" alt="<?php echo htmlspecialchars($jogo['time2']); ?> Logo">
                    <div class="time-nome"><?php echo htmlspecialchars($jogo['time2']); ?></div>
                </div>
            </div>
            <div class="canal">
                <?php if (count($jogo['canal_logos']) > 0): ?>
                    <?php foreach ($jogo['canal_logos'] as $canal_logo): ?>
                        <img src="<?php echo htmlspecialchars($canal_logo); ?>" alt="Canal Logo">
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="transmissao">Transmissão não disponível</div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<div class="mensagem-aviso">
    COMPARTILHAR API SPORT OU VENDA NÃO AUTORIZADA SERÁ FEITO O BLOQUEIO E SEM DIREITO DE REEMBOLSO
</div>

<!-- Bloqueio de inspecionar código-fonte e inspetor de elementos -->
<script>
    // Desabilitar clique com o botão direito
    document.addEventListener('contextmenu', function(e) {
        e.preventDefault();
    });

    // Desabilitar atalhos de teclado (F12, Ctrl+Shift+I, Ctrl+U)
    document.addEventListener('keydown', function(e) {
        if (e.key === 'F12' || 
            (e.ctrlKey && e.shiftKey && e.key === 'I') || 
            (e.ctrlKey && e.key === 'U')) {
            e.preventDefault();
        }
    });

    // Mensagem de advertência ao abrir o inspetor de elementos
    setInterval(function() {
        const devtools = window.devtools || { isOpen: false };
        if (devtools.isOpen) {
            alert('O uso do inspetor de elementos não é permitido!');
            window.location.href = '/';
        }
    }, 1000);
</script>

</body>
</html>
<?php
// Processar o conteúdo do buffer de saída e ocultar os links de imagens
$html = ob_get_clean();
$html = ocultarLinksDeImagensNoHTML($html);
echo $html;

// Gerar e inserir o script de decodificação no final do HTML
echo gerarScriptDecodificacao($imagens);
?>
