<?php  
include 'auth.php';
include 'db.php';

// Função para carregar jogos do JSON
function carregarJogos() {
    $json_file = 'jogos_do_dia.json';
    if (file_exists($json_file)) {
        return json_decode(file_get_contents($json_file), true);
    } else {
        return [];
    }
}

// Função para salvar jogos no JSON no formato correto
function salvarJogos($jogos) {
    $json_file = 'jogos_do_dia.json';
    file_put_contents($json_file, json_encode($jogos, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}

// Função para ordenar os jogos por hora
function ordenarJogosPorHora($jogos) {
    usort($jogos, function($a, $b) {
        return strtotime($a['hora']) - strtotime($b['hora']);
    });
    return $jogos;
}

// Função para enviar notificação ao Telegram
function sendTelegramNotification($message) {
    $telegramToken = "TOKENN";
    $chatId = "IDDD";
    $url = "https://api.telegram.org/bot$telegramToken/sendMessage";

    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
        ],
    ];

    $context = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

// Lidar com ações de exclusão, edição e organização
if (isset($_GET['excluir'])) {
    $index = $_GET['excluir'];
    $jogos = carregarJogos();
    array_splice($jogos, $index, 1);
    salvarJogos($jogos);
    header("Location: configurar_jogo.php");
    exit();
}

if (isset($_GET['editar'])) {
    $index = $_GET['editar'];
    $jogos = carregarJogos();
    $jogoParaEditar = $jogos[$index];
}

if (isset($_GET['organizar'])) {
    $jogos = carregarJogos();
    $jogos = ordenarJogosPorHora($jogos);
    salvarJogos($jogos);
    header("Location: configurar_jogo.php");
    exit();
}

// Notificação para o Telegram
if (isset($_GET['notificar'])) {
    $jogos = carregarJogos();

    // Data atual formatada
    $dataAtual = date('d/m/Y');

    // Inicializando a mensagem com um cabeçalho esportivo mais chamativo
    $mensagem = "⚽️🏆 <b><u>Jogos Imperdíveis de Hoje!</u></b> 🏆⚽️\n";
    $mensagem .= "📅 <i>Data: $dataAtual</i>\n";
    $mensagem .= "🔥 Prepare-se para grandes emoções nos campos de futebol! 🔥\n\n";
    $mensagem .= "------------------------------------------\n\n";

    foreach ($jogos as $jogo) {
        // Detalhes do jogo com formatação esportiva mais intensa
        $mensagem .= "🏆 <b><u>" . strtoupper($jogo['campeonato']) . "</u></b> 🏆\n";
        $mensagem .= "⚽️ <b>" . $jogo['time1_nome'] . " (" . $jogo['time1'] . ")</b> 🆚 <b>" . $jogo['time2_nome'] . " (" . $jogo['time2'] . ")</b>\n";
        $mensagem .= "⏰ <b>Horário:</b> <i>" . $jogo['hora'] . "</i>\n";

        // Listar todos os canais
        $canais = array_map(function($canal) {
            return $canal['nome'];
        }, $jogo['canal_logos']);
        $mensagem .= "📺 <b>Transmissão:</b> <i>" . implode(', ', $canais) . "</i>\n";

        // Separação esportiva entre os jogos
        $mensagem .= "------------------------------------------\n\n";
    }

    // Mensagem final de incentivo com tema esportivo
    $mensagem .= "⚡️ <b><u>Não perca nenhum lance!</u></b> ⚡️\n";
    $mensagem .= "🥳 <i>Convide seus amigos, prepare a pipoca e venha torcer com a gente!</i> 🍿\n";
    $mensagem .= "🎉 Vamos juntos vibrar com cada gol e cada jogada! 🎉\n";
    $mensagem .= "------------------------------------------\n";

    // Enviar notificação para o Telegram
    sendTelegramNotification($mensagem);

    header("Location: configurar_jogo.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $time1_nome = $_POST['time1'];
    $time2_nome = $_POST['time2'];
    $hora = $_POST['hora'];
    $canais = $_POST['canais'];
    $acao = $_POST['acao'];
    $campeonato = $_POST['campeonato'];

    $jogos = carregarJogos();

    // Buscar abreviações dos times com base nos nomes fornecidos
    $query = "SELECT abreviacao_time, nome_time, logo_time FROM times WHERE nome_time IN ('$time1_nome', '$time2_nome')";
    $result = mysqli_query($conn, $query);
    
    $abreviacoes = [];
    $logos = [];

    // Corrigir a inversão dos times e logos
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['nome_time'] == $time1_nome) {
            $time1_abrev = $row['abreviacao_time'];
            $logo1 = $row['logo_time'];
        } else if ($row['nome_time'] == $time2_nome) {
            $time2_abrev = $row['abreviacao_time'];
            $logo2 = $row['logo_time'];
        }
    }

    // Verificar se ambos os times foram encontrados corretamente
    if (!isset($time1_abrev) || !isset($time2_abrev)) {
        $time1_abrev = $time1_nome;
        $time2_abrev = $time2_nome;
    }

    $data = [
        "campeonato" => $campeonato,
        "time1_nome" => $time1_nome, // Nome completo do time 1
        "time1" => $time1_abrev, // Abreviação do time 1
        "logo1" => $logo1 ?? "", // Adicionar logo correspondente ao time 1
        "time2_nome" => $time2_nome, // Nome completo do time 2
        "time2" => $time2_abrev, // Abreviação do time 2
        "logo2" => $logo2 ?? "", // Adicionar logo correspondente ao time 2
        "hora" => $hora,
        "canal_logos" => [] // Adicionar logos e nomes dos canais correspondentes
    ];

    // Carregar logos e nomes dos canais
    $sql_canais = "SELECT nome_canal, logo_canal FROM canais WHERE id IN (" . implode(',', $canais) . ")";
    $result_canais = mysqli_query($conn, $sql_canais);
    $canais_logos = mysqli_fetch_all($result_canais, MYSQLI_ASSOC);

    foreach ($canais_logos as $canal) {
        $data['canal_logos'][] = [
            'nome' => $canal['nome_canal'],
            'logo' => $canal['logo_canal']
        ];
    }

    if ($acao == "editar") {
        $index = $_POST['index'];
        $jogos[$index] = $data; // Atualiza o jogo no índice correto
    } else {
        $jogos[] = $data; // Adiciona um novo jogo
    }

    $jogos = ordenarJogosPorHora($jogos); // Ordena os jogos por hora antes de salvar
    salvarJogos($jogos);
    header("Location: configurar_jogo.php");
    exit();
}

$jogos = carregarJogos();
$jogos = ordenarJogosPorHora($jogos); // Ordena os jogos por hora antes de exibir
?>


<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurar Jogo</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 1200px;
            display: flex;
            justify-content: space-between;
        }
        .form-container {
            width: 48%;
        }
        .list-container {
            width: 48%;
            max-height: 400px;
            overflow-y: auto;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
            text-align: center;
        }
        input[type="text"], input[type="time"], select {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        .button-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 10px;
        }
        button:hover {
            background-color: #4cae4c;
        }
        .home-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-left: 10px;
        }
        .home-button:hover {
            background-color: #0056b3;
        }
        .list-item {
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .list-item div {
            flex-grow: 1;
        }
        .list-item button {
            background-color: #d9534f;
            margin-left: 10px;
        }
        .list-item button:hover {
            background-color: #c9302c;
        }
    </style>
</head>
<body>

<div class="container">

    <div class="form-container">
        <h1><?php echo isset($jogoParaEditar) ? 'Editar Jogo' : 'Configurar Jogo'; ?></h1>
        <form method="POST" action="configurar_jogo.php">
            <select name="campeonato" required>
                <option value="" disabled selected>Selecione o Campeonato</option>
                <?php
                $result = mysqli_query($conn, "SELECT * FROM campeonatos ORDER BY nome ASC");
                while ($row = mysqli_fetch_assoc($result)) {
                    $selected = isset($jogoParaEditar) && $row['nome'] == $jogoParaEditar['campeonato'] ? 'selected' : '';
                    echo "<option value='" . $row['nome'] . "' $selected>" . $row['nome'] . "</option>";
                }
                ?>
            </select>
            <input type="text" name="time1" placeholder="Digite o nome do primeiro time" list="times" value="<?php echo isset($jogoParaEditar) ? $jogoParaEditar['time1'] : ''; ?>" required>
            <input type="text" name="time2" placeholder="Digite o nome do segundo time" list="times" value="<?php echo isset($jogoParaEditar) ? $jogoParaEditar['time2'] : ''; ?>" required>
            <input type="time" name="hora" placeholder="Hora do Jogo" value="<?php echo isset($jogoParaEditar) ? $jogoParaEditar['hora'] : ''; ?>" required>
<select name="canais[]" multiple required>
    <?php
    // Carregar lista de canais
    $result = mysqli_query($conn, "SELECT * FROM canais ORDER BY nome_canal ASC");
    while ($row = mysqli_fetch_assoc($result)) {
        // Verifica se o canal já foi selecionado
        $selected = '';
        if (isset($jogoParaEditar)) {
            foreach ($jogoParaEditar['canal_logos'] as $canal) {
                if ($row['logo_canal'] == $canal['logo']) {
                    $selected = 'selected';
                    break;
                }
            }
        }
        echo "<option value='" . $row['id'] . "' $selected>" . $row['nome_canal'] . "</option>";
    }
    ?>
</select>
            <?php if (isset($jogoParaEditar)): ?>
                <input type="hidden" name="index" value="<?php echo $_GET['editar']; ?>">
                <div class="button-group">
                    <button type="submit" name="acao" value="editar">Salvar Alterações</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php else: ?>
                <div class="button-group">
                    <button type="submit" name="acao" value="criar">Criar Novo Jogo</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="list-container">
        <h1>Jogos Cadastrados</h1>
        <?php
        if (empty($jogos)) {
            echo "<p>Nenhum jogo cadastrado.</p>";
        } else {
            foreach ($jogos as $index => $jogo) {
                echo "<div class='list-item'>";
                echo "<div>{$jogo['time1']} vs {$jogo['time2']} - {$jogo['hora']}</div>";
                echo "<div>";
                echo "<a href='configurar_jogo.php?editar=$index'><button>Editar</button></a>";
                echo "<a href='configurar_jogo.php?excluir=$index'><button>Excluir</button></a>";
                echo "</div>";
                echo "</div>";
            }
        }
        ?>
<div style="display: flex; gap: 10px;">
    <form method="GET" action="configurar_jogo.php">
        <button type="submit" name="organizar">Organizar Jogos</button>
    </form>
    <form method="GET" action="configurar_jogo.php">
        <button type="submit" name="notificar">Notificar</button>
    </form>
</div>
    </div>
</div>

<datalist id="times">
    <?php
    // Carregar lista de nomes dos times do banco de dados
    $result = mysqli_query($conn, "SELECT nome_time FROM times ORDER BY nome_time ASC");
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<option value='" . htmlspecialchars($row['nome_time']) . "'></option>";
    }
    ?>
</datalist>

</body>
</html>