<?php
include 'auth.php';
include 'db.php';

// Função para carregar usuários do banco de dados
function carregarUsuarios() {
    global $conn;
    $result = mysqli_query($conn, "SELECT * FROM usuarios");
    return mysqli_fetch_all($result, MYSQLI_ASSOC);
}

// Lidar com ações de exclusão
if (isset($_GET['excluir'])) {
    $id = $_GET['excluir'];
    mysqli_query($conn, "DELETE FROM usuarios WHERE id = $id");
    header("Location: cadastrar_usuario.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $usuario = $_POST['usuario'];
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT); // Hashing da senha

    mysqli_query($conn, "INSERT INTO usuarios (usuario, senha) VALUES ('$usuario', '$senha')");
    header("Location: cadastrar_usuario.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Usuário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 1200px;
            display: flex;
            justify-content: space-between;
        }
        .form-container {
            width: 48%;
        }
        .list-container {
            width: 48%;
            max-height: 400px;
            overflow-y: auto;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
            text-align: center;
        }
        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        .button-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 10px;
        }
        button:hover {
            background-color: #4cae4c;
        }
        .home-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-left: 10px;
        }
        .home-button:hover {
            background-color: #0056b3;
        }
        .list-item {
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .list-item div {
            flex-grow: 1;
        }
        .list-item button {
            background-color: #d9534f;
            margin-left: 10px;
        }
        .list-item button:hover {
            background-color: #c9302c;
        }
    </style>
</head>
<body>

<div class="container">

    <div class="form-container">
        <h1>Cadastrar Usuário</h1>
        <form method="POST" action="cadastrar_usuario.php">
            <input type="text" name="usuario" placeholder="Digite o nome do usuário" required>
            <input type="password" name="senha" placeholder="Digite a senha" required>
            <div class="button-group">
                <button type="submit">Cadastrar</button>
                <a href="index.php" class="home-button">Home</a>
            </div>
        </form>
    </div>

    <div class="list-container">
        <h1>Usuários Cadastrados</h1>
        <?php
        $usuarios = carregarUsuarios();
        if (empty($usuarios)) {
            echo "<p>Nenhum usuário cadastrado.</p>";
        } else {
            foreach ($usuarios as $usuario) {
                echo "<div class='list-item'>";
                echo "<div>{$usuario['usuario']}</div>";
                echo "<div>";
                echo "<a href='cadastrar_usuario.php?excluir={$usuario['id']}'><button>Excluir</button></a>";
                echo "</div>";
                echo "</div>";
            }
        }
        ?>
    </div>
</div>

</body>
</html>
