<?php 
include 'auth.php';
include 'db.php';

// Função para carregar times do banco de dados
function carregarTimes($conn) {
    $result = mysqli_query($conn, "SELECT * FROM times");
    return mysqli_fetch_all($result, MYSQLI_ASSOC);
}

// Função para excluir um time
if (isset($_GET['excluir'])) {
    $id = $_GET['excluir'];
    $query = "DELETE FROM times WHERE id = $id";
    $resultado = mysqli_query($conn, $query);
    
    if ($resultado) {
        echo "<script>alert('Time excluído com sucesso!');</script>";
    } else {
        echo "<script>alert('Erro ao excluir time.');</script>";
    }
    
    header("Location: adicionar_time.php");
    exit();
}

// Função para carregar um time para edição
if (isset($_GET['editar'])) {
    $id = $_GET['editar'];
    $result = mysqli_query($conn, "SELECT * FROM times WHERE id = $id");
    $timeParaEditar = mysqli_fetch_assoc($result);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nome_time = $_POST['nome_time'];
    $abreviacao_time = $_POST['abreviacao_time']; // Novo campo para abreviação
    $logo_time = $_POST['logo_time'];
    $acao = $_POST['acao'];

    if ($acao == "editar") {
        $id = $_POST['id'];
        $query = "UPDATE times SET nome_time='$nome_time', abreviacao_time='$abreviacao_time', logo_time='$logo_time' WHERE id = $id"; // Abreviação adicionada
        $resultado = mysqli_query($conn, $query);
        
        if ($resultado) {
            echo "<script>alert('Time editado com sucesso!');</script>";
        } else {
            echo "<script>alert('Erro ao editar time.');</script>";
        }
    } else {
        $query = "INSERT INTO times (nome_time, abreviacao_time, logo_time) VALUES ('$nome_time', '$abreviacao_time', '$logo_time')"; // Abreviação adicionada
        $resultado = mysqli_query($conn, $query);
        
        if ($resultado) {
            echo "<script>alert('Time adicionado com sucesso!');</script>";
        } else {
            echo "<script>alert('Erro ao adicionar time.');</script>";
        }
    }
    
    header("Location: adicionar_time.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adicionar Time</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 1200px;
            display: flex;
            justify-content: space-between;
        }
        .form-container {
            width: 48%;
        }
        .list-container {
            width: 48%;
            max-height: 400px;
            overflow-y: auto;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
            text-align: center;
        }
        input[type="text"], input[type="url"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        .button-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 10px;
        }
        button:hover {
            background-color: #4cae4c;
        }
        .home-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-left: 10px;
        }
        .home-button:hover {
            background-color: #0056b3;
        }
        .list-item {
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .list-item div {
            flex-grow: 1;
        }
        .list-item button {
            background-color: #d9534f;
            margin-left: 10px;
        }
        .list-item button:hover {
            background-color: #c9302c;
        }
    </style>
</head>
<body>

<div class="container">

    <div class="form-container">
        <h1><?php echo isset($timeParaEditar) ? 'Editar Time' : 'Adicionar Time'; ?></h1>
        <form method="POST" action="adicionar_time.php">
            <input type="text" name="nome_time" placeholder="Nome do Time" value="<?php echo isset($timeParaEditar) ? $timeParaEditar['nome_time'] : ''; ?>" required>
            <input type="text" name="abreviacao_time" placeholder="Abreviação do Time" value="<?php echo isset($timeParaEditar) ? $timeParaEditar['abreviacao_time'] : ''; ?>" required> <!-- Campo de abreviação -->
            <input type="url" name="logo_time" placeholder="URL do Logo" value="<?php echo isset($timeParaEditar) ? $timeParaEditar['logo_time'] : ''; ?>" required>
            <?php if (isset($timeParaEditar)): ?>
                <input type="hidden" name="id" value="<?php echo $timeParaEditar['id']; ?>">
                <div class="button-group">
                    <button type="submit" name="acao" value="editar">Salvar Alterações</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php else: ?>
                <div class="button-group">
                    <button type="submit" name="acao" value="criar">Adicionar Time</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="list-container">
        <h1>Times Cadastrados</h1>
        <?php
        $times = carregarTimes($conn);
        if (empty($times)) {
            echo "<p>Nenhum time cadastrado.</p>";
        } else {
            foreach ($times as $time) {
                echo "<div class='list-item'>";
                echo "<div>{$time['nome_time']} ({$time['abreviacao_time']})</div>"; // Exibir nome e abreviação
                echo "<div>";
                echo "<a href='adicionar_time.php?editar={$time['id']}'><button>Editar</button></a>";
                echo "<a href='adicionar_time.php?excluir={$time['id']}'><button>Excluir</button></a>";
                echo "</div>";
                echo "</div>";
            }
        }
        ?>
    </div>
</div>

</body>
</html>
