<?php
include 'auth.php';
include 'db.php';

// Função para carregar canais do banco de dados
function carregarCanais($conn) {
    $result = mysqli_query($conn, "SELECT * FROM canais");
    return mysqli_fetch_all($result, MYSQLI_ASSOC);
}

// Função para excluir um canal
if (isset($_GET['excluir'])) {
    $id = $_GET['excluir'];
    $query = "DELETE FROM canais WHERE id = $id";
    $resultado = mysqli_query($conn, $query);
    
    if ($resultado) {
        echo "<script>alert('Canal excluído com sucesso!');</script>";
    } else {
        echo "<script>alert('Erro ao excluir canal.');</script>";
    }
    
    header("Location: adicionar_canal.php");
    exit();
}

// Função para carregar um canal para edição
if (isset($_GET['editar'])) {
    $id = $_GET['editar'];
    $result = mysqli_query($conn, "SELECT * FROM canais WHERE id = $id");
    $canalParaEditar = mysqli_fetch_assoc($result);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nome_canal = $_POST['nome_canal'];
    $logo_canal = $_POST['logo_canal'];
    $acao = $_POST['acao'];

    if ($acao == "editar") {
        $id = $_POST['id'];
        $query = "UPDATE canais SET nome_canal='$nome_canal', logo_canal='$logo_canal' WHERE id = $id";
        $resultado = mysqli_query($conn, $query);
        
        if ($resultado) {
            echo "<script>alert('Canal editado com sucesso!');</script>";
        } else {
            echo "<script>alert('Erro ao editar canal.');</script>";
        }
    } else {
        $query = "INSERT INTO canais (nome_canal, logo_canal) VALUES ('$nome_canal', '$logo_canal')";
        $resultado = mysqli_query($conn, $query);
        
        if ($resultado) {
            echo "<script>alert('Canal adicionado com sucesso!');</script>";
        } else {
            echo "<script>alert('Erro ao adicionar canal.');</script>";
        }
    }
    
    header("Location: adicionar_canal.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adicionar Canal</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('https://i.imgur.com/RqlrW3E.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 1200px;
            display: flex;
            justify-content: space-between;
        }
        .form-container {
            width: 48%;
        }
        .list-container {
            width: 48%;
            max-height: 400px;
            overflow-y: auto;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
            text-align: center;
        }
        input[type="text"], input[type="url"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        .button-group {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        button {
            background-color: #5cb85c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            margin-right: 10px;
        }
        button:hover {
            background-color: #4cae4c;
        }
        .home-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-left: 10px;
        }
        .home-button:hover {
            background-color: #0056b3;
        }
        .list-item {
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .list-item div {
            flex-grow: 1;
        }
        .list-item button {
            background-color: #d9534f;
            margin-left: 10px;
        }
        .list-item button:hover {
            background-color: #c9302c;
        }
    </style>
</head>
<body>

<div class="container">

    <div class="form-container">
        <h1><?php echo isset($canalParaEditar) ? 'Editar Canal' : 'Adicionar Canal'; ?></h1>
        <form method="POST" action="adicionar_canal.php">
            <input type="text" name="nome_canal" placeholder="Nome do Canal" value="<?php echo isset($canalParaEditar) ? $canalParaEditar['nome_canal'] : ''; ?>" required>
            <input type="url" name="logo_canal" placeholder="URL do Logo" value="<?php echo isset($canalParaEditar) ? $canalParaEditar['logo_canal'] : ''; ?>" required>
            <?php if (isset($canalParaEditar)): ?>
                <input type="hidden" name="id" value="<?php echo $canalParaEditar['id']; ?>">
                <div class="button-group">
                    <button type="submit" name="acao" value="editar">Salvar Alterações</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php else: ?>
                <div class="button-group">
                    <button type="submit" name="acao" value="criar">Adicionar Canal</button>
                    <a href="index.php" class="home-button">Home</a>
                </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="list-container">
        <h1>Canais Cadastrados</h1>
        <?php
        $canais = carregarCanais($conn);
        if (empty($canais)) {
            echo "<p>Nenhum canal cadastrado.</p>";
        } else {
            foreach ($canais as $canal) {
                echo "<div class='list-item'>";
                echo "<div>{$canal['nome_canal']}</div>";
                echo "<div>";
                echo "<a href='adicionar_canal.php?editar={$canal['id']}'><button>Editar</button></a>";
                echo "<a href='adicionar_canal.php?excluir={$canal['id']}'><button>Excluir</button></a>";
                echo "</div>";
                echo "</div>";
            }
        }
        ?>
    </div>
</div>

</body>
</html>
